/*-*-c++-*-
 * $Id: clistview.cpp,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#include "clistview.h"
#include "csearchlistdialog.h"

CListView::CListView(QWidget *parent, const char *name )
	: QListView(parent,name)
	, oFindColumn(-1)
{
	setAllColumnsShowFocus(true);
}

CListView::~CListView()
{
}

void
CListView::closeEvent(QCloseEvent* e)
{
	emit sigClosed(this);
	e->accept();
}

void
CListView::keyPressEvent(QKeyEvent* e)
{
}

QString
CListView::rootName() const
{
	return firstChild()->text(0);
}

QString
CListView::rootValue() const
{
	return firstChild()->text(1);
}

QSize
CListView::sizeHint() const
{
	return QSize();
}

QString
CListView::findItem(const QString& str)
{
	const unsigned int len = str.length();
	
	if (firstChild() != 0) {
		QListViewItem* cur = 0;
		unsigned int ll = 0;
		
		// find shortest matching entry
		for (QListViewItemIterator it(firstChild()); it.current() != 0; ++it) {
			if (str == it.current()->text(oFindColumn).left(len)) { // item found
				if (cur == 0 || it.current()->text(oFindColumn).length() < ll) {
					cur = it.current();
					ll = cur->text(oFindColumn).length();
				}
			}
		}
		
		if (cur != 0) {
			// o.k., selected the found item and ensure that all parent nodes are open
			setSelected(cur, true);
			QListViewItem* walker = cur->parent();
			while (walker != 0) {
				walker->setOpen(true);
				walker = walker->parent();
			}
			
			ensureItemVisible(cur);
			
			return cur->text(oFindColumn);
		}		
	}
	
	return QString::null;
}

void
CListView::findDialog()
{
	if (oFindColumn > -1) {
		CSearchListDialog* sd = new CSearchListDialog(this, oFindColumn);
		sd->setFindColumn(oFindColumn);
		sd->show();
	}
}
