/*-*-c++-*-
 * $Id: cgraphbutton.h,v 1.1 2002/01/28 15:38:32 holzheu Exp $
 *
 * This file is part of qlcrash, a GUI for the dump-analysis tool lcrash.
 *
 * Copyright (C) 2001 IBM Deutschland Entwicklung GmbH, IBM Corporation
 *
 * Authors:
 * Michael Geselbracht (let@users.sourceforge.net)
 * Fritz Elfert (elfert@de.ibm.com)
 * Michael Holzheu (holzheu@de.ibm.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser Public License as published by
 * the Free Software Foundation; either version 2.1 of the License, or
 * (at your option) any later version. See the file COPYING for more
 * information.
 */
#ifndef CGRAPHBUTTON_H
#define CGRAPHBUTTON_H

#include <qbutton.h>
#include <qpixmap.h>

/**A general tool button.
  *@author Michael Geselbracht
  */

class CGraphButton : public QButton {
	Q_OBJECT
	
public: 
	CGraphButton(QWidget* parent, const char* name=0);
	~CGraphButton();
	
	void resizeButton();
	void setOnPixmap(const QPixmap&);
	void setOffPixmap(const QPixmap&);
	
	// specify if this is a toggle button
	void setToggle(bool);
	
protected:
	virtual void drawButton(QPainter*);
	virtual void drawButtonLabel(QPainter*);
	
protected slots:
	void slotToggle(bool);
	
private:
	QPixmap oOnPM;
	QPixmap oOffPM;
};

#endif
