/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
#include <lcrash.h>

/*
 * report_cmd() -- run the 'report' command.
 */
void
report_cmd(command_t *cmd)
{
	do_report(cmd->flags, cmd->ofp);
}

#define _REPORT_USAGE "[-w outfile]"

/*
 * report_usage() -- Print the usage string for the 'report' command.
 */
void
report_usage(command_t *cmd)
{
	CMD_USAGE(cmd, _REPORT_USAGE);
}

/*
 * report_help() -- Print the help information for the 'report' command.
 */
void
report_help(command_t *cmd)
{
	CMD_HELP(cmd, _REPORT_USAGE,
	"Display a crash dump report. The report contains information about "
	"the system state when the kernel failure occurred.");
}

/*
 * report_parse() -- Parse the command line arguments for 'report'.
 */
int
report_parse(command_t *cmd)
{
	if (set_cmd_flags(cmd, (C_FALSE|C_WRITE), 0)) {
		return(1);
	}
	return(0);
}

/*
 * report_complete() -- Complete arguments of 'report' command.
 */
char *
report_complete(command_t *cmd)
{
	char *ret;

	/* complete standard options (for example, -w option) arguments
	 */
	if ((ret = complete_standard_options(cmd)) != NOT_COMPLETED) {
		return(ret);
	}
	fprintf(cmd->ofp, "\n");
	report_usage(cmd);
	return(DRAW_NEW_ENTIRE_LINE);
}
