/*
 *  lcrash/arch/s390/lib/s390-util.c
 *   S/390 utility functions
 *
 *    Copyright (C) 2000 IBM Deutschland Entwicklung GmbH,
 *                       IBM Corporation
 *    Author(s): Michael Holzheu (holzheu@de.ibm.com),
 *
 *    Bugreports to: <Linux390@de.ibm.com>
 */


#include <lcrash.h>
#include <asm/lc_s390-util.h>

extern int pc_offset(kaddr_t pc);

void s390_print_lowcore(void* lc, FILE* ofp)
{
        syment_t* sym;
        unsigned long* ul_tmp;
        unsigned int*  ui_tmp; 

        fprintf(ofp," LOWCORE INFO:\n");
	ul_tmp = K_PTR(lc,"_lowcore","st_status_fixed_logout");
        fprintf(ofp,"  -psw      : %#016lx %#016lx\n", ul_tmp[0],ul_tmp[1]);

        sym = kl_lkup_symaddr(ul_tmp[1]);
        if(sym && (ul_tmp != 0)){
                fprintf(ofp,"  -function : %s+%u\n",sym->s_name,
                        pc_offset(ul_tmp[1]));
        }
        else{
                fprintf(ofp,"  -function : not found in System map\n");
        }

        ui_tmp = K_PTR(lc,"_lowcore","prefixreg_save_area");
        fprintf(ofp,"  -prefix   : %#010x\n", ui_tmp[0]);

	ui_tmp = K_PTR(lc,"_lowcore","cpu_timer_save_area");	
        fprintf(ofp,"  -cpu timer: %#010x %#010x\n", ui_tmp[0], ui_tmp[1]);
	ui_tmp = K_PTR(lc,"_lowcore","clock_comp_save_area");
        fprintf(ofp,"  -clock cmp: %#010x %#010x\n",ui_tmp[0], ui_tmp[1]);
        fprintf(ofp,"  -general registers:\n");
	ul_tmp = K_PTR(lc,"_lowcore","gpregs_save_area");
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[0],ul_tmp[1]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[2],ul_tmp[3]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[4],ul_tmp[5]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[6],ul_tmp[7]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[8],ul_tmp[9]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[10],ul_tmp[11]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[12],ul_tmp[13]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[14],ul_tmp[15]);

        fprintf(ofp,"  -access registers:\n");
	ui_tmp = K_PTR(lc,"_lowcore","access_regs_save_area");
	fprintf(ofp,"     %#08x %#08x %#08x %#08x\n",ui_tmp[0],ui_tmp[1],ui_tmp[2],ui_tmp[3]);
        fprintf(ofp,"     %#08x %#08x %#08x %#08x\n",ui_tmp[4],ui_tmp[5],ui_tmp[6],ui_tmp[7]);
        fprintf(ofp,"     %#08x %#08x %#08x %#08x\n",ui_tmp[8],ui_tmp[9],ui_tmp[10],ui_tmp[11]);
        fprintf(ofp,"     %#08x %#08x %#08x %#08x\n",ui_tmp[12],ui_tmp[13],ui_tmp[14],ui_tmp[15]);
        fprintf(ofp,"  -control registers:\n");
	ul_tmp = K_PTR(lc,"_lowcore","cregs_save_area");
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[0],ul_tmp[1]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[2],ul_tmp[3]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[4],ul_tmp[5]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[6],ul_tmp[7]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[8],ul_tmp[9]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[10],ul_tmp[11]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[12],ul_tmp[13]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[14],ul_tmp[15]);
        
        fprintf(ofp,"  -floating point registers:\n");
	ul_tmp = K_PTR(lc,"_lowcore","floating_pt_save_area");

	fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[0],ul_tmp[1]);
	fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[2],ul_tmp[3]);
	fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[4],ul_tmp[5]);
	fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[6],ul_tmp[7]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[8],ul_tmp[9]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[10],ul_tmp[11]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[12],ul_tmp[13]);
        fprintf(ofp,"     %#016lx %#016lx\n",ul_tmp[14],ul_tmp[15]);
}

