.TH lkstm 8
.SH NAME
lkstm \- Control maskset in LKST.
.br
.SH SYNOPSIS
lkstm \fIcommand\fR [ \fIoption(s)\fR ]
.SH DESCRIPTION
This command controls maskset in LKST, such as reading, writing, deletion, changing, and displaying list of all masksets.
.SH COMMANDS
.TP
.B all
Output a list of masksets and display content of all masksets.


.TP 
\fBdelete/del \-m \fImaskset_id \fR| \fB\-n \fImaskset_name
Delete a maskset.
.TP 1i
.B \ \ \ \ \ \ \-m \fImaskset_id
Specify the id of a maskset to delete.
.TP 1i
.B \ \ \ \ \ \ \-n \fImaskset_name
Specify the name of a maskset to delete.
.PP

.TP
.B list/ls
Output a list of all masksets.

.TP
\fBread \fR[\fB\-m \fImaskset_id \fR| \fB\-n \fImaskset_name\fR] [\fB-A\fR] [\fB-a\fR] [\fB-d\fR]
Output the contents of a maskset.
.TP 1i
.B \ \ \ \ \ \ \-m \fImaskset_id
Specify the id of a maskset to read. 
.TP 1i
.B \ \ \ \ \ \ \-n \fImaskset_name
Specify the name of a maskset to read. If both \fImaskset_id \fRand 
\fImaskset_name \fRare omitted, read the currently selected maskset.
.TP 1i
.B \ \ \ \ \ \ \-A
Read all masksets.
.TP 1i
.B \ \ \ \ \ \ \-a
Do not omit not registered event type. It ignored if "\-d" option is
specified.
.TP 1i
.B \ \ \ \ \ \ \-d
Do not display a description of each event type.
.PP

.TP
\fBset \-m \fImaskset_id \fR| \fB\-n \fImaskset_name
Change currently selected maskset. 
.TP 1i
.B \ \ \ \ \ \ \-m \fImaskset_id
Specify the id of a maskset to select.
.TP 1i
.B \ \ \ \ \ \ \-n \fImaskset_name
Specify the name of a maskset to select.
.PP

.TP 
\fBwrite \fR[\fB\-m \fImaskset_id\fR] [\fB-f \fIfile_name\fR] [\fB-n \fImaskset_name\fR] [\fB-S\fR]
Write a new maskset.
.TP 1i
.B \ \ \ \ \ \ \-m \fImaskset_id
Specify the id of a maskset to write. If omitted, unused id is
selected automatically.
.TP 1i
.B \ \ \ \ \ \ \-f \fIfile_name
Specify a file which the content of the maskset is written. If ommited,
standard input is used as input. This file can be created by "read"
command as template.
.TP 1i
.B \ \ \ \ \ \ \-n \fImaskset_name
Specify the name of new maskset. If omitted, the name of new maskset is set 
as "new_maskset0". When it is already used, change to "new_maskset1". 
And when it is used too, change to "new_maskset2", and so on
(IOW, this increments tag number.)
.TP 1i
.B \ \ \ \ \ \ \-S
Change the currently selected maskset to the written maskset.
.PP

.TP 
\fBfind \fB-n \fImaskset_name\fR
find the id of a maskset from its name.
.TP 1i
.B \ \ \ \ \ \ \-n \fImaskset_name
Specify the name of a maskset to find.
.TP 1i
.B \ \ \ \ \ \ NOTE:
If no maskset has \fImaskset_name\fR, then outputs 255 (=LKST_MASKSET_ID_VOID).
.PP

.TP 
\fBconfig/conf \fR[\fB\-m \fImaskset_id \fR| \fB-n \fImaskset_name\fR] <\fIevent_type\fR> <\fIevent-handler_id\fR>
Config a maskset.
.TP 1i
.B \ \ \ \ \ \ \-m \fImaskset_id
Specify the id of a maskset to config. If both of id and name are omitted, 
current selected id is used.
.TP 1i
.B \ \ \ \ \ \ \-n \fImaskset_name
Specify the name of a maskset to config.
.TP 1i
.B \ \ \ \ \ \ \fIevent_type
Specify the type of an event to change. 
.TP 1i
.B \ \ \ \ \ \ \fIevent-handler_id
Specify the id of an event-handler to change to. 
.PP

.TP
.B version/ver
Print version of this command.
.PP

.TP
.B help
Print help message.
.PP
.SH RETURN VALUE
.TP
.B 0
success
.TP
.B Except 0
failure
.SH REFERENCES
.BR lkst (8),
.BR ioctl(LKST_IOC_MASKSET_READ) (2),
.BR ioctl(LKST_IOC_MASKSET_WRITE) (2),
.BR ioctl(LKST_IOC_MASKSET_LIST) (2),
.BR ioctl(LKST_IOC_MASKSET_SET) (2),
.BR ioctl(LKST_IOC_MASKSET_DELETE) (2)
