/*
 * Copyright 1999 Silicon Graphics, Inc. All rights reserved.
 */
/* #define KLT_BASE         1 */
/* #define KLT_STRUCT       2 */
/* #define KLT_UNION        3 */
/* #define KLT_ENUMERATION  4 */
/* #define KLT_MEMBER       5 */
/* #define KLT_ARRAY        6 */
/* #define KLT_POINTER      7 */
/* #define KLT_TYPEDEF      8 */
/* #define KLT_FUNCTION     9 */
/* #define KLT_VARIABLE    10 */
/* #define KLT_SRCFILE     11 */
/* #define KLT_INCOMPLETE  98 */
/* #define KLT_UNKNOWN     99 */
#define KLT_BASE         0x001
#define KLT_STRUCT       0x002
#define KLT_UNION        0x004
#define KLT_ENUMERATION  0x008
#define KLT_MEMBER       0x010
#define KLT_ARRAY        0x020
#define KLT_POINTER      0x040
#define KLT_TYPEDEF      0x080
#define KLT_FUNCTION     0x100
#define KLT_VARIABLE     0x200
#define KLT_SRCFILE      0x400
#define KLT_INCOMPLETE   0x4000
#define KLT_UNKNOWN      0x8000
#define KLT_TYPE	(KLT_BASE|KLT_STRUCT|KLT_UNION|KLT_ENUMERATION)

#define TYP_SETUP_FLG  		0x01
#define TYP_TYPESTRING_FLG	0x02
#define TYP_INCOMPLETE_FLG  	0x04
#define TYP_XREFERENCE_FLG  	0x08

#define NO_INDENT           0x10000000
#define SUPPRESS_NAME       0x20000000
#define SUPPRESS_NL         0x40000000
#define SUPPRESS_SEMI_COLON 0x80000000

extern int numnmlist;

#define KL_TYPEINFO()	(numnmlist)

typedef struct kltype_s {
	char			*kl_name;	  /* type name */
        char                    *kl_typestr;      /* 'typecast' string */
	void			*kl_ptr;	  /* ptr to arch typeinfo */
        int                      kl_flags;        /* (e.g., STAB_FLG) */
        int                      kl_type;         /* (e.g., KLT_TYPEDEF) */
        int                      kl_offset;       /* offset to 1st byte */
        int                      kl_size;         /* number of bytes */
        int                      kl_bit_offset;   /* offset to 1st data bit */
        int                      kl_bit_size;     /* total num of data bits */
        int                      kl_encoding;     /* for base value types */
        int                      kl_low_bounds;   /* for arrays */
        int                      kl_high_bounds;  /* for arrays */
        unsigned int             kl_value;        /* enum value, etc. */
        struct kltype_s         *kl_member;       /* struct/union member list */
	struct kltype_s         *kl_next;         /* hash lists, etc. */
	struct kltype_s         *kl_realtype;     /* pointer to real type */
	struct kltype_s         *kl_indextype;    /* pointer to index_type */
	struct kltype_s         *kl_elementtype;  /* pointer to element_type */
#ifdef NOT
        int                      kl_namelist;     /* index of namelist */
#endif
} kltype_t;

/* Flag values
 */
#define K_HEX            0x1
#define K_OCTAL          0x2
#define K_BINARY         0x4

/* Base type encoding values
 */
#define ENC_CHAR	0x01
#define ENC_SIGNED	0x02
#define ENC_UNSIGNED	0x04
#define ENC_FLOAT	0x08
#define ENC_ADDRESS	0x10
#define ENC_UNDEFINED	0x20

/*
#define TYPE_NUM_SLOTS 256
#define TYPE_NUM_HASH(TNUM) (((((uint64_t)TNUM) >> 32) \
	+ ((TNUM) & 0xffffffff)) & (TYPE_NUM_SLOTS - 1))
*/	

/* Maximum number of open namelists
 */
#define MAXNMLIST 10

typedef struct nmlist_s {
	int              index;
	char	       	*namelist;
	void		*private;	/* pointer to private control struct */
	string_table_t 	*stringtab;
} nmlist_t;

extern nmlist_t nmlist[];
extern int numnmlist;
extern int curnmlist;

/* Function prototypes
 */
kltype_t *kl_find_sym(
	char *		/* symbol name */,
	int		/* symbol type */);

kltype_t *kl_first_sym(
	int 		/* symbol type */);

kltype_t *kl_next_sym(
	kltype_t *	/* kltype_t pointer */);

kltype_t *kl_find_type(
	char *		/* type name */);

kltype_t *kl_first_type(void);

kltype_t *kl_next_type(
	kltype_t *	/* kltype_t pointer */);

kltype_t *kl_realtype(
	kltype_t *	/* kltype_t pointer */,
	int		/* type number */);

int kl_type_size(
	kltype_t *	/* kltype_t pointer */);

int kl_struct_len(
	char *		/* struct name */);

kltype_t *kl_find_member(
	char *		/* struct name */, 
	char *		/* member name */);

kltype_t *kl_get_member(
	kltype_t *	/* kltype_t pointer */,
	char *		/* member name */);

int kl_member_offset(
	char *		/* struct name */, 
	char *		/* member name */);

int kl_is_member(
	char *		/* struct name */, 
	char *		/* member name */);

int kl_member_size(
	char *		/* struct name */, 
	char *		/* member name */);

void kl_print_type(
	void *		/* pointer to data */, 
	kltype_t *	/* pointer to type information */, 
	int		/* indent level */, 
	int		/* flags */, 
	FILE *		/* output file */);
