/* $Id: lkstlogger.c,v 1.5 2002/06/28 11:27:53 indoh Exp $ */
/* command/lkstlogger.c */

/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2002 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by K.Hatasaki <keisukeh@crl.hitachi.co.jp>
 *
 ************************************************************/

#include <getopt.h>
#include "command.h"

#define NAME	"lkstlogger"
#define VERSION "1.1"

#define NR_CMD 3

void usage(void);
void log_write(int, lkst_arg_t, lkst_arg_t, lkst_arg_t, lkst_arg_t);

void call_usage(int*, char**);
void call_version(int*, char**);
void call_log_write(int*, char**);

int main(int argc, char **argv)
{

	int i;

	struct command cmd[] = 
	{
		[0] = {"help", &call_usage},
		[1] = {"ver", &call_version},
		[2] = {"version", &call_version},
	};

	if (argc == 1) { /* no command */
		usage();
	} else {
		for (i = 0; i < NR_CMD; i++) {
			if (!strcmp(cmd[i].name, argv[1])) {
				cmd[i].func(&argc, argv);
				break;
			}
		}
		if (i == NR_CMD)
			call_log_write(&argc, argv);
	}

	exit(0);
}

void usage(void)
{
	printf("This tells LKST that a specified event has occurred.\n");
	printf("Usage:\n  %s -ev evet_type [-a1 data1] [-a2 data2] [-a3 data3] [-a4 data4]\n", NAME);
	printf("  %s command\n\n", NAME);
	printf("<OPTTION>\n");
	printf("-ev event_type\n\t\tSpecify an occurred event type.\n\n");
	printf("-a1 data1 -a2 data2 -a3 data3 -a4 data4\n");
	printf("\t\tSpecify variable data to be transferred to LKST.\n\n");
	printf("<COMMAND>\n");
	printf("version/ver\tPrint version information.\n");
	printf("help\t\tPrint this message.\n");
	exit(0);
}

void call_usage(int *argc, char **argv)
{
	usage();
}

void call_version(int *argc, char **argv)
{
	version(NAME, VERSION);
}

void call_log_write(int *argc, char **argv)
{
	int c;
	int event_set = 0;
	int event_type = 0;

	lkst_arg_t data[4] = {
		[0 ... 3] = 0
	};

	struct option opt[] = {
		[0] = {"ev", 1, NULL, 1},
		[1] = {"a1", 1, NULL, 2},
		[2] = {"a2", 1, NULL, 3},
		[3] = {"a3", 1, NULL, 4},
		[4] = {"a4", 1, NULL, 5},
		[5] = {NULL, 0, NULL, 0}
	};

	while((c = getopt_long_only(*argc, argv, "ev:a1:a2:a3:a4:", opt, NULL)) != EOF) {
		switch(c) {
		case 1 :
			event_set = 1;
			event_type = strtoul(optarg, NULL, 0);
			break;
		case 2 :
		case 3 :
		case 4 :
		case 5 :
			data[c - 2] = strtoul(optarg, NULL, 0);
			break;
		default :
			usage();
		}
	}

	if (!event_set)
		needopt();

	log_write(event_type, data[0], data[1], data[2], data[3]);
}

void log_write(int event_type, lkst_arg_t data1, lkst_arg_t data2,
	       lkst_arg_t data3, lkst_arg_t data4)
{
	int fd;
	int retval;
	struct lkst_entry_args arg;

	arg.event_type = event_type;
	arg.arg1 = data1;
	arg.arg2 = data2;
	arg.arg3 = data3;
	arg.arg4 = data4;

	fd = open_dev();

	retval = ioctl(fd, LKST_IOC_ENTRY_LOG, &arg); /* entry_log */

	if (retval) {
		fprintf(stderr, "ioctl() error: %s\n", strerror(errno));
		exit(1);
	}

	printf("The event reported successfully.\n");
 
	close(fd);
}
