/* $Id: command.c,v 1.3 2002/04/12 01:37:25 indoh Exp $ */
/* command/command.c */

/************************************************************
 *
 * COPYRIGHT (C) HITACHI,LTD. 2002 ALL RIGHTS RESERVED.
 * WRITTEN BY HITACHI SYSTEMS DEVELOPMENT LABORATORY,
 *            HITACHI CENTRAL RESEARCH LABORATORY.
 *
 * Created by K.Hatasaki <keisukeh@crl.hitachi.co.jp>
 *
 ************************************************************/

#include "command.h"

void version(char *name, char *version)
{
	printf("%s %s\n%s\n", name, version, COPYRIGHT);
	exit(0);
}

void needopt()
{
	printf("Specified command requires more option(s).\n");
	usage();
}

void badcommand(char *cmd_name)
{
	printf("Invalid command : %s\n", cmd_name);
	usage();
}

int open_dev(void)
{
	int fd;
	if ((fd = open("/dev/lkst", O_RDONLY)) < 0) {
		perror("ioctl");
		printf("Error: cannot open LKST device!\n");
		exit(1);
	}
	return fd;
}
