#!/bin/bash
# LKST patch-porting helper script
# COPYRIGHT (C) HITACHI,LTD. 2003-2004
# Written by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>

if [ $# -ne 1 -a $# -ne 2 ]; then
echo "Usage: scripts/porting.sh <linux tarball (linux-xxx.tar.bz2/tar.gz)> [patchdir]"
echo " Or    scripts/porting.sh <linux srctree (linux-xxx/)> [patchdir]"
exit 1
fi

SCRDIR=`dirname $0`
[ "$SCRDIR" ] || SCRDIR=`pwd`
source $SCRDIR/../lkst.version
source $SCRDIR/functions

SCRDIR=`rp2ap $SCRDIR`
ROOTDIR=`rp2ap $SCRDIR/../`
WORKDIR=$ROOTDIR/porting

PATCHDIR=$ROOTDIR/patches
if [ -d "$2" ] ; then
 PATCHDIR=$2
fi
source $PATCHDIR/kernel.version

if [ -f $1 ]; then
 KTARBZ=$1 # kernel tarball
 KSRCTR=
 KDIR=`basename $KTARBZ | sed -e s/.tar.bz2$//g -e s/.tar.gz$//g`
elif [ -d $1 ]; then
 KTARBZ=
 KSRCTR=$1 # kernel source tree
 KDIR=`basename $KSRCTR`
 KSRCTR=`rp2ap $KSRCTR`
else
 exit 1;
fi
NEW_KERNEL=`echo $KDIR | sed -e s/^linux-//g`

BASE_KERNEL_ABBR=`mkabbr $BASE_KERNEL`
NEW_KERNEL_ABBR=`mkabbr $NEW_KERNEL`

[ -d $WORKDIR ] && echo "$WORKDIR already exists, abort." && exit 1
mkdir $WORKDIR
[ -d $WORKDIR ] || exit 0;

[ -z "$EDITOR" ] && EDITOR=vi

function porting () {
local SDIR=$WORKDIR/$1
local DDIR=$WORKDIR/$2
local SPATCH=$3
local DPATCH=$4
[ -z "$DPATCH" ] && DPATCH=`basename $SPATCH`
mkdir $DDIR || rm -rf $DDIR/*
lndir -silent $SDIR $DDIR
patch -p1 -d $DDIR < $SPATCH &> $DDIR/patch.log
[ `grep -v ^patching $DDIR/patch.log| wc -l` -ne 0 ] && ( echo "patch porting might fail, please fix."; $EDITOR $DDIR/patch.log )
echo "----"Making $DPATCH... >> $WORKDIR/patch-all.log
cat $DDIR/patch.log >> $WORKDIR/patch-all.log
rm `find $DDIR -name \*~ -o -name \*.orig -o -name \*.rej` $DDIR/patch.log
( cd $WORKDIR ; \
   diffdir $1 $2 "$WORKDIR/$DPATCH")
}

function diffing () {
local SDIR=$WORKDIR/$1
local DDIR=$WORKDIR/$2
local DPATCH=$3
( cd $WORKDIR ; \
  diff -Naru $1 $2 > $WORKDIR/$DPATCH )
}

if [ "$KTARBZ" ]; then
 echo "Infrating"
 if [ -z `echo $KTARBZ | grep \\.gz$` ] ; then
	tar xjf $KTARBZ -C $WORKDIR
 else
	tar xzf $KTARBZ -C $WORKDIR
 fi
else
 echo "Linking"
 mkdir $WORKDIR/$KDIR
 lndir -silent $KSRCTR $WORKDIR/$KDIR
fi

echo "Porting kernelhooks base patch"
porting $KDIR linux-hooks-base \
	$PATCHDIR/kernelhooks-v1.8-$BASE_KERNEL_ABBR-base.patch \
	kernelhooks-v1.8-$NEW_KERNEL_ABBR-base.patch

echo "Porting kernelhooks fix kconfig patch"
porting linux-hooks-base linux-hooks-fix_conf \
	$PATCHDIR/kernelhooks-v1.8-fix_kconfig.patch

echo "Porting kernelhooks fix makefile patch"
porting linux-hooks-fix_conf linux-hooks-fix_make \
	$PATCHDIR/kernelhooks-v1.8-fix_kmakefile.patch

echo "Porting kernelhooks resolve dependency patch"
porting linux-hooks-fix_make linux-hooks-resolve \
	$PATCHDIR/kernelhooks-v1.8-resolve_dependency.patch

echo "Porting kernelhooks ia64 support patch"
porting linux-hooks-resolve linux-hooks-ia64 \
	$PATCHDIR/kernelhooks-v1.8-support_ia64.patch

echo "Porting kernelhooks x86-64 support patch"
porting linux-hooks-resolve linux-hooks-x86_64 \
	$PATCHDIR/kernelhooks-v1.8-support_x86_64.patch

echo "Porting preassigned patch"
porting $KDIR linux-preassigned \
	$PATCHDIR/preassigned-$BASE_KERNEL.patch \
	preassigned-$NEW_KERNEL.patch

function apply_new_hooks() {
local SDIR=$1
local DDIR=$2
mkdir $DDIR || rm -rf $DDIR/*
lndir -silent $SDIR $DDIR
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-$NEW_KERNEL_ABBR-base.patch > $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-fix_kconfig.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-fix_kmakefile.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-resolve_dependency.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-support_ia64.patch >> $WORKDIR/patch.log
patch -p1 -d $DDIR < $WORKDIR/kernelhooks-v1.8-support_x86_64.patch >> $WORKDIR/patch.log
rm `find $DDIR -name \*~ -o -name \*.orig -o -name \*.rej` &> /dev/null
}

echo "Preparing hooks "
apply_new_hooks $WORKDIR/linux-preassigned $WORKDIR/linux-hooks

echo "Porting LKST core patch"
porting linux-hooks linux-lkst-core $PATCHDIR/lkst-core.patch

echo "Porting LKST for standerd events patch"
porting linux-lkst-core linux-lkst-std $PATCHDIR/lkst-events-std.patch

echo "Porting LKST early logging patch"
porting linux-lkst-std linux-lkst-earlylog $PATCHDIR/lkst-earlylog.patch

echo "Porting LKST extend events log patch"
porting linux-lkst-earlylog linux-lkst-extev $PATCHDIR/lkst-events-ext1.patch

echo "Porting LKST for ignore inline patch"
porting linux-lkst-extev linux-lkst-full $PATCHDIR/lkst-ign-inline.patch

echo "Making LKST fullset patch"
diffing linux-hooks linux-lkst-full linux26.patch

echo "Porting vmsync patch"
porting $KDIR linux-vmsync \
	$PATCHDIR/vmsync-$BASE_KERNEL.patch \
	vmsync-$NEW_KERNEL.patch

echo "Preparing hooks "
apply_new_hooks $WORKDIR/linux-vmsync $WORKDIR/linux-lkst-orig
patch -p1 -d $WORKDIR/linux-lkst-orig < $WORKDIR/linux26.patch >> \
	$WORKDIR/patch.log
rm `find $WORKDIR/linux-lkst-orig -name \*~ -o -name \*.orig -o -name \*.rej` \
	&> /dev/null

echo "Porting LKST patch"
porting linux-lkst-orig linux-lkst-vmsync $PATCHDIR/lkst-use_vmsync.patch

echo "BASE_KERNEL=$NEW_KERNEL" > $WORKDIR/kernel.version

echo "Ported"
