#!/bin/sh
# COPYRIGHT (C) HITACHI,LTD. 2004
# Written by M.Hiramatsu <hiramatu@sdl.hitachi.co.jp>
[ $# != 1 ] && echo "Usage: procstate.sh PID" && exit 0

TRACEDB=./trace.db
TRACELOG=./trace.csv
UNK=0
SLP=1
RDY=2
RUN=3
TASK_RUNNING=0x00000000

function pid2padr()
{
	local PID PADR
	PID=`printf "%08d" $1`
	PADR=`grep $PID $TRACEDB | cut -d \  -f 2`
	if [ "$PADR" ] ; then 
		echo $PADR
	else
		echo "0x00000000"
	fi
}

function main_trace()
{
local PADR=$1
local EV CPU PID SC NS AG1 AG1L AG1H AG2 AG2L AG2H AG3 AG3L AG3H AG4 AG4L AG4H
STAT=$UNK
OSTAT=$UNK
echo $PADR $STAT
while test 1 ; do
read -s EV CPU PID SC NS AG1L AG2L AG3L AG4L 
[ $EV ] || exit 1
if [ $EV = \"context_switch\" ]; then 
   if [ $AG2L = $PADR ] ;then
      STAT=$RUN
   elif [ $AG1L = $PADR ] ;then
      STAT=$SLP
      [ $AG3L = $TASK_RUNNING ] && STAT=$RDY
   fi
elif [ $EV = \"process_wakeup\" ]; then
   [ $AG1L = $PADR ] && STAT=$RDY
fi

if [ $STAT != $OSTAT ]; then
   echo $SC.$NS $STAT
   OSTAT=$STAT
fi
done
}

PADR=`pid2padr $1`

main_trace $PADR < $TRACELOG
