package org.pigeonblood.test;

import org.lixm.core.common.LIXMException;
import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLModelizer;
import org.lixm.core.common.XMLType;
import org.lixm.core.model.XMLModel;
import org.pigeonblood.impl.core.list.SimpleDocumentList;
import org.pigeonblood.impl.core.modelizer.SimpleXMLModelizer;
import org.pigeonblood.impl.optional.cnif.AbstractXMLCrawler;
import org.pigeonblood.impl.optional.cnif.AbstractXMLIndexer;

public class Test2 {

	private XMLModelizer modelizer;
	private SimpleDocumentList list1;
	private SimpleDocumentList list2;

	class Test2Crawler extends AbstractXMLCrawler{

		public Test2Crawler(SimpleDocumentList list, AbstractXMLIndexer indexer) {
			super(list, indexer);
		}

		@Override
		public boolean accept(XMLModel model) throws LIXMPhaseException {
			return (model.getXMLType() == XMLType.START_TAG || model.getXMLType() == XMLType.END_TAG);
		}
		
	}

	class Test2Indexer extends AbstractXMLIndexer{

		public Test2Indexer(SimpleDocumentList list) {
			super(list);
		}

		@Override
		public int compare(XMLModel arg0, XMLModel arg1)
				throws UnsupportedOperationException {
			return 1;
		}

		@Override
		public void receive(XMLModel model) throws LIXMException {
			super.receive(model);
		}
	}

	public Test2() {
		list1 = new SimpleDocumentList(10);
		try {
			modelizer = new SimpleXMLModelizer(list1);
		} catch (LIXMPhaseException e) {
			e.printStackTrace();
			System.exit(1);
		}

		try {
			modelizer.modelize("res/test2.xml");
		} catch (LIXMPhaseException e) {
			e.printStackTrace();
			System.exit(1);
		}

		for (XMLModel model : list1) {
			System.out.println(model);
		}

		list2 = new SimpleDocumentList(10);
		Test2Indexer indexer = new Test2Indexer(list2);
		Test2Crawler crawler = new Test2Crawler(list1, indexer); 

		try {
			crawler.dispath();
		} catch (LIXMException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.exit(1);
		}

		try {
			list2 = (SimpleDocumentList) indexer.getList();
		} catch (LIXMPhaseException e) {
			e.printStackTrace();
			System.exit(1);
		}

		System.out.println();
		System.out.println("̃XgJn^OƏI^Oo");
		System.out.println();

		for (XMLModel model : list2) {
			System.out.println(model);
		}
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Test2 test = new Test2();
	}

}
