package org.pigeonblood.impl.core.modelizer;

import org.lixm.core.list.AttributesList;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.XMLModel;
import org.lixm.optional.v15.atattch.LIXMConfigurationException;
import org.lixm.optional.v15.atattch.LIXMConfigurationSupport;
import org.lixm.optional.v16.framework.model.EndCdataModelImpl;
import org.lixm.optional.v16.framework.model.EndDocumentModelImpl;
import org.lixm.optional.v16.framework.model.StartCdataModelImpl;
import org.lixm.optional.v16.framework.model.StartDocumentModelImpl;
import org.pigeonblood.impl.core.model.DynamicAttributeModelImpl;
import org.pigeonblood.impl.core.model.DynamicCharactersModelImpl;
import org.pigeonblood.impl.core.model.DynamicCommentModelImpl;
import org.pigeonblood.impl.core.model.DynamicElementModelImpl;
import org.pigeonblood.impl.core.model.DynamicEndTagModelImpl;
import org.pigeonblood.impl.core.model.DynamicProcessingInstructionModelImpl;
import org.pigeonblood.impl.core.model.DynamicStartTagModelImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

/**
 * SAX𗘗pfCU̎łB
 * ̃nhTuNX{@link org.pigeonblood.impl.core.modelizer.SimpleXMLModelizer SimpleXMLModelizer}
 * ɓnƂŃfCY̓JX^}CYł܂B
 * @author tasogare
 * @since 0.1
 */
public class SimpleModelizerHandler extends DefaultHandler implements
		LexicalHandler {

	protected LIXMConfigurationSupport configuration;
	protected XMLDocumentList<XMLModel> list;

	protected SimpleModelizerHandler(LIXMConfigurationSupport configuration,
			XMLDocumentList<XMLModel> list) {
		this.configuration = configuration;
		this.list = list;
	}

	public void characters(char[] chars, int start, int length)
			throws SAXException {
		list.add(new DynamicCharactersModelImpl(
				new String(chars, start, length)));
	}

	public void comment(char[] ch, int start, int length) throws SAXException {
		/*
		 * BUGS 000_000_000[RtBMAݒ肳ĂȂꍇ̏Y]
		 * RtBMAݒ肳ĂȂꍇ̓RgfCYĒɖ߂悤ɂB
		 */
		if (configuration == null) {
			list
					.add(new DynamicCommentModelImpl(new String(ch, start,
							length)));
			return;
		}

		try {
			if (!configuration
					.getFeature(LIXMConfigurationSupport.NONE_MODELIZED_COMMENTS)) {
				list.add(new DynamicCommentModelImpl(new String(ch, start,
						length)));
			}
		} catch (LIXMConfigurationException e) {

			/*
			 * PigeonbloodXMLConfigurationNONE_MODELIZED_COMMENTSF̂
			 * LIXMConfigurationException鎖͂肦ȂB āAA[T[VB
			 */
			throw new AssertionError(e);
		}
	}

	public void endCDATA() throws SAXException {

		if (configuration == null) {
			list.add(new EndCdataModelImpl());
			return;
		}

		try {
			if (!configuration
					.getFeature(LIXMConfigurationSupport.EXPAND_CDATA)) {
				list.add(new EndCdataModelImpl());
			}
		} catch (LIXMConfigurationException e) {

			/*
			 * PigeonbloodXMLConfigurationEXPAND_CDATAF̂
			 * LIXMConfigurationException鎖͂肦ȂB āAA[T[VB
			 */
			throw new AssertionError(e);
		}
	}

	public void endDocument() throws SAXException {
		list.add(new EndDocumentModelImpl());
	}

	public void endDTD() throws SAXException {
	}

	public void endElement(String uri, String localName, String qName)
			throws SAXException {

		boolean outColon = qName.indexOf(':') == -1;
		String pref = outColon ? "" : qName.substring(0, qName.indexOf(':'));
		String name;

		if (localName.equals("") || localName == null) {

			// vtBbNꍇ
			if (!outColon) {
				name = qName.substring(qName.indexOf(':') + 1);
			}
			// vtBbNȂꍇ
			else {
				name = qName;
			}
		} else {
			name = localName;
		}

		list.add(new DynamicEndTagModelImpl(new DynamicElementModelImpl(name,
				pref, uri)));
	}

	public void endEntity(String arg0) throws SAXException {
	}

	public void endPrefixMapping(String arg0) throws SAXException {
	}

	public void ignorableWhitespace(char[] chars, int start, int length)
			throws SAXException {
		list.add(new DynamicCharactersModelImpl(
				new String(chars, start, length)));
	}

	public void processingInstruction(String target, String data)
			throws SAXException {
		// xml-style PIɂ͑ΉȂ
		list.add(new DynamicProcessingInstructionModelImpl(target, data));
	}

	public void setDocumentLocator(Locator arg0) {
	}

	public void skippedEntity(String arg0) throws SAXException {
	}

	public void startCDATA() throws SAXException {

		if (configuration == null) {
			list.add(new StartCdataModelImpl());
			return;
		}

		try {
			if (!configuration
					.getFeature(LIXMConfigurationSupport.EXPAND_CDATA)) {
				list.add(new StartCdataModelImpl());
			}
		} catch (LIXMConfigurationException e) {

			/*
			 * PigeonbloodXMLConfigurationEXPAND_CDATAF̂
			 * LIXMConfigurationException鎖͂肦ȂB āAA[T[VB
			 */
			throw new AssertionError(e);
		}
	}

	public void startDocument() throws SAXException {
		list.add(new StartDocumentModelImpl());
	}

	public void startDTD(String arg0, String arg1, String arg2)
			throws SAXException {
	}

	public void startElement(String uri, String localName, String qName,
			Attributes atts) throws SAXException {
		final int MAX_SIZE = atts.getLength();
		DynamicAttributeModelImpl[] attrs = new DynamicAttributeModelImpl[MAX_SIZE];

		boolean outColon = false;
		for (int i = 0; i < MAX_SIZE; i++) {
			String qAName = atts.getQName(i);
			outColon = qAName.indexOf(':') == -1;
			String aPref = outColon /* qAName.equals("") */? "" : qAName
					.substring(0, qAName.indexOf(':'));

			attrs[i] = new DynamicAttributeModelImpl(atts.getLocalName(i), atts
					.getValue(i), aPref, atts.getURI(i));
		}

		outColon = qName.indexOf(':') == -1;
		String pref = outColon ? "" : qName.substring(0, qName.indexOf(':'));
		String name;

		if (localName.equals("") || localName == null) {

			// vtBbNꍇ
			if (!outColon) {
				name = qName.substring(qName.indexOf(':') + 1);
			}
			// vtBbNȂꍇ
			else {
				name = qName;
			}
		} else {
			name = localName;
		}

		list.add(new DynamicStartTagModelImpl(new DynamicElementModelImpl(name,
				pref, uri), new AttributesList(attrs)));
	}

	public void startEntity(String arg0) throws SAXException {
	}

	public void startPrefixMapping(String arg0, String arg1)
			throws SAXException {
	}

}
