package org.lixm.optional.v16.framework.model;

import org.lixm.core.common.XMLType;
import org.lixm.core.model.AbstractModel;
import org.lixm.core.model.XmlDeclModel;

/**
 * <p>XML錾f܂B</p>
 * 
 * @author tasogare
 * @since 1.5
 * 
 */
public class XmlDeclModelImpl extends AbstractModel implements XmlDeclModel {

	protected String version;

	protected String encoding;

	protected String standalone;

	private XmlDeclModelImpl() {
	}

	/**
	 * <p>XML̃@[WAGR[fBOAX^hA錾w肵ď܂B</p>
	 * 
	 * @param version
	 *        XML̃@[W
	 * @param encodeing
	 *        XML̃GR[fBO
	 * @param standalone
	 *        XML̃X^hA錾
	 */
	public XmlDeclModelImpl(String version, String encodeing, String standalone) {
		super(XMLType.XML_DECL);
		this.version = version;
		this.encoding = encodeing;
		this.standalone = standalone;
	}

	/**
	 * <p>XML̃@[W擾܂B</p>
	 * 
	 * @return XML̃@[W
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * <p>XML̃GR[fBO擾܂B</p>
	 * 
	 * @return XML̃GR[fBO
	 */
	public String getEncoding() {
		return encoding;
	}

	/**
	 * <p>XML̃X^hA錾擾܂B</p>
	 * 
	 * @return XML̃X^hA錾
	 */
	public String getStandalone() {
		return standalone;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "<?xml " + " version=" + "\"" + getVersion() + "\""
				+ " encodeing=" + "\"" + getEncoding() + "\"" + " standalone="
				+ "\"" + getStandalone() + "\"" + "?>";
	}

	/**
	 * <p>f̓ꐫ_Iɒׂ̌ʂԂ܂B</p>
	 * 
	 * @return ̃fȂ<code>true</code>AႤȂ<code>false</code>B
	 */
	@Override
	public boolean equals(Object o) {
		if (!super.equals(o))
			return false;
		return (this.toString() == o.toString());
	}

	/**
	 * <p>f̃N[Ԃ܂B</p>
	 * 
	 * @return f̃N[
	 * @since 1.6
	 */
	@Override
	public Object clone() {
		return (Object) new XmlDeclModelImpl(this.version, this.encoding,
				this.standalone);

	}

}