package org.xpnd.component.action.impl.actions;

import org.lixm.core.common.LIXMException;
import org.lixm.core.model.EndTagModel;
import org.lixm.core.model.StartTagModel;
import org.xpnd.component.action.ActionSharedContext;
import org.xpnd.component.action.ElementAction;
import org.xpnd.component.renderer.HeilevelRenderer;

public class METAElementActions implements ActionSharedContext {

    
    class METAElementAction implements ElementAction {

	public int actionEndTag(EndTagModel endTag)  throws LIXMException{
	    inMETAElement = false;
	    return 0;
	}

	public int actionStartTag(StartTagModel startTag)  throws LIXMException{
	    if(inMETAElement) throw new LIXMException("metavf͓qɏo܂B");
	    inMETAElement = true;
	    return 0;
	}

    }

    class CacheElementAction implements ElementAction {
	    public  CacheElementAction(){
	    }
	    public int actionEndTag(EndTagModel endTag)  throws LIXMException{
		return 0;
	    }

	    public int actionStartTag(StartTagModel startTag)  throws LIXMException{
		if(inMETAElement){
		    renderer.processCache(startTag.getAttributes().getName("src").getValue());
		}else{
		    throw new LIXMException("cachevfmetavfɃlXgȂ΂Ȃ܂B");
		}
		return 0;
	    }

	}

    private HeilevelRenderer renderer;
    private boolean inMETAElement;
    private CacheElementAction cacheElem;
    private METAElementAction metaElem;

    public METAElementActions(HeilevelRenderer renderer){
	this.renderer = renderer;
	this.cacheElem = new CacheElementAction();
	this.metaElem = new METAElementAction();
    }

    public ElementAction getAction(String actionName) {
	if(actionName.equals("cache")){
	    return cacheElem;
	}else if(actionName.equals("meta")){
	    return metaElem;
	}else{
	    return null;
	}
    }

}
