package org.xpnd.component.action.impl;

import org.lixm.core.common.LIXMException;
import org.lixm.core.model.EndTagModel;
import org.lixm.core.model.StartTagModel;
import org.xpnd.component.action.ElementAction;
import org.xpnd.component.renderer.HeilevelRenderer;

/**
 * delay
 * @author tasogare
 *
 */
public class SleepElementAction implements ElementAction {
    private HeilevelRenderer renderer;

    public SleepElementAction(HeilevelRenderer renderer){
	this.renderer = renderer;
    }
    public int actionEndTag(EndTagModel endTag) throws LIXMException {
	return 0;
    }

    public int actionStartTag(StartTagModel startTag) throws LIXMException {
	long delay = Long.parseLong(startTag.getAttributes().getName("delay").getValue());
	try {
	    Thread.currentThread().sleep(delay);
	} catch (InterruptedException e) {
	    e.printStackTrace();
	}
	return 0;
    }

}
