package org.lixm.core.model;

import org.lixm.core.common.XMLType;


/**
 * <p>終了タグをモデル化します。</p>
 * @author tasogare
 * @version 1.0.0
 */
public class EndTagModel extends AbstractModel {

    private ElementModel elem;

    public EndTagModel(
        ElementModel element)
    {
        super(XMLType.END_TAG);
        elem = element;
    }
    /**
     * <p>この終了タグの要素名へ簡単にアクセスするための簡易メソッドです。</p>
     * @return 必ず<code>getElement().getName()</code>の値が返されます。
     */
    public String getName() {
        return getElement( ).getName( );
    }

    /**
     * <p>この終了タグの要素を取得します。</p>
     * 
     * @return 要素モデル
     */
    public ElementModel getElement() {
        return elem;
    }

    /**
     * <p>この終了タグの要素を設定します。</p>
     * 
     * @param elem 新たな終了タグの要素
     */
    public void setElement(ElementModel elem){
    	 this.elem = elem;
    }

    /**
     * <p>この終了タグのXMLとして有効な文字列表現を返します。</p>
     * 
     * @return XMLとして有効な文字列表現 
     */
    public String toEndTag() {
        return toString( );
    }

    /**
     * {@inheritDoc}
     */
    public String toString() {
        return "</" + getElement( ).toString( ) + ">";
    }

    /**
     * <p>モデルの同一性を論理的に調べその結果を返します。</p>
     * @return 同一のモデルなら<code>true</code>、違うなら<code>false</code>。
     */
    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }
}
