package org.gamelet.middleware.canvas;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

import org.gamelet.middleware.canvas.renderer.AbstractRenderer;

public abstract class BaseCanvas extends GameCanvas{

	/*
	 *	アニメーションスレッド 
	 */
	protected Thread animator;

	/*
	 * アニメーションレンダラー
	 */
	protected AbstractRenderer renderer;

	/**
	 * <p>キャンバスを生成します。</p>
	 * 
	 * @param owner キャンバスのオーナー
	 * @param suppressKeyEvents キーイベントを有効にするか？
	 * @throws Exception サブクラスの{@link #initCanvas()}で例外が発生した場合
	 */
	public BaseCanvas(boolean suppressKeyEvents) throws Exception{
		super(suppressKeyEvents);
	}

	/**
	 * レンダリングスレッドを取得します。
	 * @return レンダリングスレッド
	 */
	public final Thread getAnimator() {
		return animator;
	}

	/**
     * レンダラを取得します。
     * @return レンダラ
     */
    public final AbstractRenderer getRenderer() {
    	return renderer;
    }

	/**
	 * レンダリングスレッドを設定します。
	 * 引数に渡すのはレンダラの実装です。
	 * @param renderer レンダラ
	 */
	public final void setAnimator(
		AbstractRenderer renderer)
	{
		this.renderer = renderer;
		animator = new Thread(this.renderer);
	}

	protected void hideNotify() {
		animator = null;
	}

	
	/**
	 * キャンバスを初期化します。
	 * このメソッドは必ずこのサブクラスのコンストラクタから呼び出します。
	 * 
	 * @throws Exception 初期化時の例外。
	 */
	protected abstract void initCanvas() throws Exception;

	/**
	 * 画面をクリップしセンタリングする。
	 * 
	 * @param g 描画グラフィックス
	 * @param width 幅
	 * @param height 高さ
	 */
	public void setLocationCenter(Graphics g, int width, int height){

	    System.out.println("clip rect : " + width + " * " + height);

	    g.setColor(000000);
	    g.fillRect(0, 0, getWidth(), getHeight());

	    System.out.println("translate Location : " + ( getWidth() - width ) / 2 + " * " + ( getHeight() - height ) / 2);
	    g.translate(
		( getWidth() - width ) / 2,
		( getHeight() - height ) / 2
	    );

	    g.clipRect(0, 0, width, height);
	}

	/**
	 * キャンバスを描画します。
	 */ 
	public final void renderCanvas(int clipWidh, int clipHeight){

		Graphics g = getGraphics( );
		setLocationCenter(g, clipWidh, clipHeight);

		((AbstractRenderer)getRenderer( )).renderContents(g);
	}

	protected void showNotify() {
		animator = new Thread(renderer);
		animator.start( );
	}

}
