package org.pigeonblood.impl.optional.cnif;

import java.util.Stack;

import org.lixm.core.common.LIXMException;
import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.AbstractModel;
import org.lixm.optional.v16.framework.cnif.XMLIndexer;
import org.pigeonblood.impl.core.list.SimpleDocumentList;

/**
 * <p>XMLCfNT̒PȒێłB</p>
 * 
 * <p>RXgN^̈ɂ͐VɃCfbNXꂽf
 * i[邽߂ɋ̃Xgn܂B</p>
 * 
 * <p>fN[[̎擾ł͂ȂA
 * RtꂽԂŊi[ꍇ{@link #compare(AbstractModel, AbstractModel)}
 * {@link #receive(AbstractModel)}
 * {@linkplain #compare(AbstractModel, AbstractModel)}
 * 𗘗p悤ɍĎĂB</p>
 * 
 * <p>ʏ̎ł{@linkplain #compare(AbstractModel, AbstractModel)}pĂ܂B
 * ܂AKv͂܂B</p>
 * 
 * @author tasogare
 * @version 0.4
 * @since 0.2
 */
public abstract class AbstractXMLIndexer implements XMLIndexer<AbstractModel> {

	private Stack<AbstractModel> stack;
	private SimpleDocumentList list;

	private boolean stackFull = false;

	private AbstractXMLIndexer(){
	}

	/**
	 * <p>B̃RXgN^łB</p>
	 * @param list N[ɑIꂽfi[VȃXg
	 */
	public AbstractXMLIndexer(SimpleDocumentList list){
		this.list = list;
		stack = new Stack<AbstractModel>();
	}

	/**
	 * {@inheritDoc}
	 */
	public abstract int compare(AbstractModel arg0, AbstractModel arg1) throws UnsupportedOperationException;

	/**
	 * {@inheritDoc}
	 */
	@SuppressWarnings("unchecked")
	public <E extends AbstractModel> XMLDocumentList<E> getList()
	    throws LIXMPhaseException
	{
		SimpleDocumentList list = demandList();

		if(list == null){
			throw new LIXMPhaseException(
				new NullPointerException("XgnullłB"),
				LIXMPhaseException.PHASE_OTHER);
		}

		return (XMLDocumentList<E>) list;
	}

	/**
	 * <p>N[ɂĐVȃXgɉ郂fIA
	 * CfNTɃfBXpb`܂B</p>
	 * 
	 * <p>̂ƂɎ󂯎̂̃\bhłB</p>
	 * 
	 * @param model N[If
	 */
	public void receive(
	    AbstractModel model) throws LIXMException
	{
		if(model == null){
			throw new LIXMException(new NullPointerException());
		}

        stack.push(model);
//		demandList( );
	}

	/**
     * <p>X^bNƃXg̃TCYvX^bN烊Xgփf߂A
     * ̃XgԂBłȂꍇ<code>null</code>ԂB</p>
     */
    private SimpleDocumentList demandList() {
    	/*
    	 * O
    	 */
    	if(stackFull) return list;

    	list.addAll(stack);
    	list.setSeal(true);
    	stackFull = true;
    	return list;

    }


}
