package org.pigeonblood.impl.core.modelizer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;

import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLModelizer;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.AbstractModel;
import org.lixm.optional.v15.atattch.LIXMConfigurable;
import org.lixm.optional.v15.atattch.LIXMConfigurationException;
import org.lixm.optional.v15.atattch.LIXMConfigurationSupport;
import org.pigeonblood.test.Test5Handler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/**
 * @TODO of[^
 * @author tasogare
 *
 */
public class SimpleXMLModelizer implements XMLModelizer, LIXMConfigurable{

    private SAXParserFactory saxf;
    private SAXParser saxp;

    private SimpleModelizerHandler handler;

    private LIXMConfigurationSupport configuration;
    private XMLDocumentList<AbstractModel> list;

    private SimpleXMLModelizer() throws LIXMPhaseException{
	saxf = SAXParserFactory.newInstance();
    }

    public SimpleXMLModelizer(XMLDocumentList<AbstractModel> list) throws LIXMPhaseException{
	this();
	setList(list);
    }

    public SimpleXMLModelizer(
	    XMLDocumentList<AbstractModel> list, LIXMConfigurationSupport configure)
	    throws LIXMPhaseException
    {
	this(list);
	this.configuration = configure;
    }

    public void setList(XMLDocumentList<AbstractModel> list){
	this.list = list;
    }

    @Override
    public XMLDocumentList<? extends AbstractModel> getList() {
	return list;
    }

    @Override
    public void modelize(String name) throws LIXMPhaseException {
	modelize(getClass().getClassLoader().getResourceAsStream(name));
    }

    public void modelize(InputStream is) throws LIXMPhaseException {
	factoryInit();
	parserInit();
	startParse(getXMLReader(), is);
    }

    public void modelize(URL url) throws LIXMPhaseException {
	InputStream is = null;
	try{
	is = url.openStream();
	}catch(IOException e){
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
	}
	modelize(is);
    }

    private XMLReader getXMLReader() throws LIXMPhaseException {

	XMLReader r = null;

	try {
	    r = saxp.getXMLReader();
	} catch (SAXException e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
	}

	return r;
    }

    private void startParse(XMLReader r, InputStream is) throws LIXMPhaseException {
	try {
	    InputStream istream = is;
	    r.parse(new InputSource(istream));
	} catch (IOException e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
	} catch (SAXException e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELIZE);
	}
    }

    @Override
    public LIXMConfigurationSupport getConfigure() {
	return configuration;
    }

    @Override
    public void setConfigure(LIXMConfigurationSupport configure) {
	this.configuration = configure;
    }

    private void factoryInit() throws LIXMPhaseException {

	    saxf.setNamespaceAware(true);

	    boolean validation = false;
	    try{
		validation = getConfigure().getFeature(LIXMConfigurationSupport.VALIDATION);
	    }catch (LIXMConfigurationException e) {
		//Ȃ
	    }catch(NullPointerException e){
		//Ȃ
	    }

	    saxf.setValidating(validation);

	    if(validation){

		Schema schema = null;
		try{
		    schema = (Schema)getConfigure().getProperty(LIXMConfigurationSupport.SCHEMA);
		}catch (LIXMConfigurationException e) {
		    //Ȃ
		}catch (NullPointerException e) {
		    //Ȃ
		}

		if(validation && schema != null){
		    saxf.setSchema(schema);
		}
	    }
    }

    private void parserInit() throws LIXMPhaseException{
	try {
	    saxp = saxf.newSAXParser();
	} catch (ParserConfigurationException e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
	} catch (SAXException e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
	}

	handler = new SimpleModelizerHandler(
		getConfigure(), (XMLDocumentList<AbstractModel>)getList());

	try {
	    saxp.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", handler);
	} catch (SAXNotRecognizedException e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
	} catch (SAXNotSupportedException e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
	} catch (SAXException e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
	}

	try {
	    saxp.getXMLReader().setContentHandler(handler);
	} catch (SAXException e) {
	    throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_PREPROCESS);
	}
    }

    public SimpleModelizerHandler getHandler() {
        return handler;
    }

    public void setHandler(SimpleModelizerHandler handler) {
        this.handler = handler;
    }
}
