/*
 * Decompiled with CFR 0.152.
 */
package org.pigeonblood.impl.optional.cnif;

import java.util.NoSuchElementException;
import org.lixm.core.common.LIXMException;
import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.model.AbstractModel;
import org.lixm.optional.v15.atattch.XMLReceiver;
import org.lixm.optional.v16.framework.cnif.XMLCrawler;
import org.pigeonblood.impl.core.list.SimpleDocumentList;
import org.pigeonblood.impl.optional.cnif.AbstractXMLIndexer;

public abstract class AbstractXMLCrawler
implements XMLCrawler {
    private SimpleDocumentList list;
    private AbstractXMLIndexer indexer;
    private int headTo;
    private int tileTo;

    public AbstractXMLCrawler(SimpleDocumentList list, AbstractXMLIndexer indexer) {
        this.list = list;
        this.indexer = indexer;
        this.headTo = -1;
        this.tileTo = list.size();
    }

    public abstract boolean accept(AbstractModel var1) throws LIXMPhaseException;

    public boolean hasNext() {
        return this.headTo + 1 < this.list.size();
    }

    public boolean hasPrevious() {
        return this.tileTo - 1 > -1;
    }

    public AbstractModel next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.list.get(++this.headTo);
    }

    public AbstractModel previous() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return this.list.get(--this.tileTo);
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void dispath() throws LIXMException {
        if (this.indexer == null) {
            throw new LIXMException((Exception)new NullPointerException());
        }
        AbstractModel model = null;
        while (this.hasNext()) {
            model = this.next();
            if (!this.accept(model)) continue;
            try {
                this.indexer.receive((AbstractModel)model.clone());
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }

    public void dispath(XMLReceiver receiver) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

