/*
 * Decompiled with CFR 0.152.
 */
package org.pigeonblood.impl.core.modelizer;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLModelizer;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.AbstractModel;
import org.lixm.optional.v15.atattch.LIXMConfigurable;
import org.lixm.optional.v15.atattch.LIXMConfigurationException;
import org.lixm.optional.v15.atattch.LIXMConfigurationSupport;
import org.pigeonblood.impl.core.modelizer.SimpleModelizerHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SimpleXMLModelizer
implements XMLModelizer,
LIXMConfigurable {
    private SAXParserFactory saxf = SAXParserFactory.newInstance();
    private SAXParser saxp;
    private SimpleModelizerHandler handler;
    private LIXMConfigurationSupport configuration;
    private XMLDocumentList<AbstractModel> list;

    private SimpleXMLModelizer() throws LIXMPhaseException {
    }

    public SimpleXMLModelizer(XMLDocumentList<AbstractModel> list) throws LIXMPhaseException {
        this();
        this.setList(list);
    }

    public SimpleXMLModelizer(XMLDocumentList<AbstractModel> list, LIXMConfigurationSupport configure) throws LIXMPhaseException {
        this(list);
        this.configuration = configure;
    }

    public void setList(XMLDocumentList<AbstractModel> list) {
        this.list = list;
    }

    public XMLDocumentList<? extends AbstractModel> getList() {
        return this.list;
    }

    public void modelize(String name) throws LIXMPhaseException {
        this.modelize(this.getClass().getClassLoader().getResourceAsStream(name));
    }

    public void modelize(InputStream is) throws LIXMPhaseException {
        this.factoryInit();
        this.parserInit();
        this.startParse(this.getXMLReader(), is);
    }

    public void modelize(URL url) throws LIXMPhaseException {
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new LIXMPhaseException((Exception)e, 2);
        }
        this.modelize(is);
    }

    private XMLReader getXMLReader() throws LIXMPhaseException {
        XMLReader r = null;
        try {
            r = this.saxp.getXMLReader();
        }
        catch (SAXException e) {
            throw new LIXMPhaseException((Exception)e, 2);
        }
        return r;
    }

    private void startParse(XMLReader r, InputStream is) throws LIXMPhaseException {
        try {
            InputStream istream = is;
            r.parse(new InputSource(istream));
        }
        catch (IOException e) {
            throw new LIXMPhaseException((Exception)e, 2);
        }
        catch (SAXException e) {
            throw new LIXMPhaseException((Exception)e, 2);
        }
    }

    public LIXMConfigurationSupport getConfigure() {
        return this.configuration;
    }

    public void setConfigure(LIXMConfigurationSupport configure) {
        this.configuration = configure;
    }

    private void factoryInit() throws LIXMPhaseException {
        this.saxf.setNamespaceAware(true);
        boolean validation = false;
        try {
            validation = this.getConfigure().getFeature("http://lcs.lixm.org/feature/validation");
        }
        catch (LIXMConfigurationException lIXMConfigurationException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.saxf.setValidating(validation);
        if (validation) {
            Schema schema = null;
            try {
                schema = (Schema)this.getConfigure().getProperty("http://lcs.lixm.org/propety/schema");
            }
            catch (LIXMConfigurationException lIXMConfigurationException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (validation && schema != null) {
                this.saxf.setSchema(schema);
            }
        }
    }

    private void parserInit() throws LIXMPhaseException {
        try {
            this.saxp = this.saxf.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            throw new LIXMPhaseException((Exception)e, 0);
        }
        catch (SAXException e) {
            throw new LIXMPhaseException((Exception)e, 0);
        }
        this.handler = new SimpleModelizerHandler(this.getConfigure(), this.getList());
        try {
            this.saxp.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", this.handler);
        }
        catch (SAXNotRecognizedException e) {
            throw new LIXMPhaseException((Exception)e, 0);
        }
        catch (SAXNotSupportedException e) {
            throw new LIXMPhaseException((Exception)e, 0);
        }
        catch (SAXException e) {
            throw new LIXMPhaseException((Exception)e, 0);
        }
        try {
            this.saxp.getXMLReader().setContentHandler(this.handler);
        }
        catch (SAXException e) {
            throw new LIXMPhaseException((Exception)e, 0);
        }
    }

    public SimpleModelizerHandler getHandler() {
        return this.handler;
    }

    public void setHandler(SimpleModelizerHandler handler) {
        this.handler = handler;
    }
}

