/*
 * Decompiled with CFR 0.152.
 */
package org.pigeonblood.impl.core.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.lixm.core.list.XMLCursor;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.AbstractModel;
import org.lixm.optional.v15.atattch.XMLManipulator;

public class SimpleDocumentList
implements XMLDocumentList<AbstractModel>,
RandomAccess {
    private ArrayList<AbstractModel> models;
    private XMLCursor cursor;
    private boolean seal;

    public SimpleDocumentList(AbstractModel[] models) {
        AbstractModel[] abstractModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractModel model = abstractModelArray[n2];
            this.models.add(model);
            ++n2;
        }
        this.setSeal(true);
    }

    public SimpleDocumentList(int length) {
        this.models = new ArrayList(length);
    }

    public boolean add(AbstractModel model) throws NullPointerException, IllegalStateException {
        if (model == null) {
            throw new NullPointerException();
        }
        if (!this.isSealed()) {
            this.models.add(model);
            return true;
        }
        throw new IllegalStateException();
    }

    public boolean addAll(Collection<? extends AbstractModel> c) throws NullPointerException, IllegalStateException, ClassCastException {
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        if (c == null) {
            throw new NullPointerException();
        }
        for (AbstractModel abstractModel : c) {
            if (abstractModel.equals(null)) {
                throw new NullPointerException();
            }
            this.models.add(abstractModel);
        }
        this.models.trimToSize();
        return true;
    }

    public void clear() throws IllegalStateException {
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        this.models = new ArrayList();
    }

    public boolean contains(Object o) throws ClassCastException, NullPointerException {
        return this.models.contains(o);
    }

    public boolean containsAll(Collection<?> c) throws ClassCastException, NullPointerException {
        return this.models.containsAll(c);
    }

    public AbstractModel get(int index) {
        return this.models.get(index);
    }

    public XMLCursor getCursor() {
        if (this.cursor == null) {
            this.cursor = new SimpleXMLCursor();
        }
        return this.cursor;
    }

    public AbstractModel getRootEndTag() {
        AbstractModel model = null;
        int idx = this.getCursor().getLast();
        while (idx > -1) {
            model = this.get(idx);
            if (model.matchTypes(7)) {
                return model;
            }
            --idx;
        }
        return null;
    }

    public AbstractModel getRootStartTag() {
        AbstractModel model = null;
        int idx = this.getCursor().getFirst();
        while (idx < this.size()) {
            model = this.get(idx);
            if (model.matchTypes(6)) {
                return model;
            }
            ++idx;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.models.isEmpty();
    }

    public Iterator<AbstractModel> iterator() {
        return new SimpleXMLManipulator();
    }

    public boolean remove(Object o) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection<?> c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection<?> c) throws IllegalStateException {
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        return this.models.retainAll(c);
    }

    public int size() {
        return this.models.size();
    }

    public Object[] toArray() {
        return this.models.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.models.toArray(a);
    }

    public boolean isSealed() {
        return this.seal;
    }

    public void set(AbstractModel model, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException, NullPointerException, IllegalStateException {
        if (model == null) {
            throw new NullPointerException();
        }
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        this.models.set(index, model);
    }

    public void setSeal(boolean seal) throws IllegalStateException {
        if (this.isSealed()) {
            throw new IllegalStateException();
        }
        this.seal = seal;
    }

    private class SimpleXMLCursor
    implements XMLCursor {
        private int current;
        private int mark;

        SimpleXMLCursor() {
            this.resetIndex();
            this.resetMark();
        }

        public int dec() throws IndexOutOfBoundsException {
            if (!this.hasPrevious()) {
                throw new IndexOutOfBoundsException();
            }
            return ++this.current;
        }

        public int getFirst() {
            return 0;
        }

        public int getIndex() {
            return this.current;
        }

        public int getLast() {
            return SimpleDocumentList.this.models.size() - 1;
        }

        public XMLDocumentList<? extends AbstractModel> getList() {
            return SimpleDocumentList.this;
        }

        public int getMark() {
            return this.mark;
        }

        public boolean hasNext() {
            return this.next() < SimpleDocumentList.this.size();
        }

        public boolean hasPrevious() {
            return this.previous() > -1;
        }

        public int inc() throws IndexOutOfBoundsException {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            return ++this.current;
        }

        public int next() {
            return this.current + 1;
        }

        public int nextTag() {
            if (!this.hasNext()) {
                return -1;
            }
            int tempCurrent = this.getIndex();
            AbstractModel nextModel = null;
            int MAX_COUNT = SimpleDocumentList.this.size();
            int i = 1;
            while (tempCurrent < MAX_COUNT) {
                boolean nextModelOfStartOrEndTag;
                nextModel = SimpleDocumentList.this.get(this.getIndex() + i);
                boolean bl = nextModelOfStartOrEndTag = nextModel.matchTypes(6) || nextModel.matchTypes(7);
                if (nextModelOfStartOrEndTag) {
                    return this.getIndex() + i;
                }
                ++i;
            }
            return -1;
        }

        public int previous() {
            return this.current - 1;
        }

        public int previousTag() {
            if (!this.hasPrevious()) {
                return -1;
            }
            AbstractModel previousModel = null;
            int MAX_COUNT = this.getIndex();
            int i = 1;
            while (i != MAX_COUNT) {
                boolean previousModelOfStartOrEndTag;
                previousModel = SimpleDocumentList.this.get(this.getIndex() - i);
                boolean bl = previousModelOfStartOrEndTag = previousModel.matchTypes(6) || previousModel.matchTypes(7);
                if (previousModelOfStartOrEndTag) {
                    return this.getIndex() - i;
                }
                ++i;
            }
            return -1;
        }

        public void resetIndex() {
            this.current = -1;
        }

        public void resetMark() {
            this.mark = -1;
        }

        public void seek(int index) throws IndexOutOfBoundsException {
            this.setMark(this.current);
            this.setIndex(index);
        }

        public void setIndex(int index) throws IndexOutOfBoundsException {
            if (-1 > index || index >= SimpleDocumentList.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.current = index;
        }

        public void setMark(int index) throws IndexOutOfBoundsException {
            if (-1 > index || index >= SimpleDocumentList.this.size()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.mark = index;
        }
    }

    private class SimpleXMLManipulator
    implements XMLManipulator<AbstractModel> {
        private int headTo = -1;
        private int tileTo;

        SimpleXMLManipulator() {
            this.tileTo = SimpleDocumentList.this.size();
        }

        public boolean hasNext() {
            return this.headTo + 1 < SimpleDocumentList.this.size();
        }

        public boolean hasPrevious() {
            return this.tileTo - 1 > -1;
        }

        public AbstractModel next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (AbstractModel)SimpleDocumentList.this.models.get(++this.headTo);
        }

        public AbstractModel previous() throws NoSuchElementException {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            return (AbstractModel)SimpleDocumentList.this.models.get(--this.tileTo);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

