/**
 * <p>このパッケージはLixMが必ず実装しなければならない機能のうち
 * XMLを構成する属性をモデル化するための機能を提供します。</p>
 * 
 * <p>この機能によりプログラムコードはXMLの詳細に対し、静的に参照することが可能です。</p>
 * 
 * <h3>モデル化されるXMLを構成する属性とは？</h3>
 * 
 * <p>XMLの仕様によって定められているXML宣言、要素、属性、属性値、処理命令、コメント、
 * CDATEセクション、文字データがモデル化の対象です。</p>
 * 
 * <p>文書型宣言や文書型定義（DTD）、
 * DTDに含まれるその他の宣言および実体参照はモデル化の対象外です。</p>
 * 
 * <h4>なぜ文書型定義（DTD）や実体参照をモデル化しないか？</h4>
 * 
 * <p>LIXMではDTDやそれを関連付ける文書型宣言は今日用いられている
 * XML名前空間に対して不適合な技術であると位置づけており意図的にこれらをサポートしません。
 * この事は将来的にも変わらないでしょう。</p>
 * 
 * <p>また実体参照はXML文書の解析中に正しく解析されるべきであり実際に利用され、
 * 必要とされる情報は実体参照を解決して得られる結果です。<br>
 * このためLIXMでは実体参照もモデル化の対象外と見なしています。</p>
 * 
 * @author tasogare
 * @version 1.1.0
 * @since v08
 */ package org.lixm.core.model;
