package org.lixm.optional.v11.framework.rpf.pipeline.castom;

import org.lixm.core.common.LIXMException;
import org.lixm.core.list.XMLModelList;
import org.lixm.core.model.AbstractModel;
import org.lixm.optional.v10.atattch.XMLDispatcher;
import org.lixm.optional.v10.atattch.XMLReceiver;

/**
 * カスタムされた方法によるパイプラインです。
 * @author tasogare
 * @version 1.1.0
 * @since 1.1.0
 *
 */

public class CastomPipeLine{

	XMLDispatcher dispatcher;
	XMLReceiver receiver;
	XMLModelList list;

	private CastomPipeLine(){}

	/**
	 * <p>任意のディスパッチャを利用したコンストラクタです。</p>
	 * @param list モデルリスト
	 * @param receiver レシーバ
	 * @param dispatcher ディスパッチャ
	 */
	public CastomPipeLine(XMLModelList list, XMLReceiver receiver, XMLDispatcher dispatcher){
	    this.list = list;
	    this.receiver = receiver;
	    this.dispatcher = dispatcher;
	}

	/**
	 * カスタムされた方式によりディスパッチャからレシーバへモデルを送ります。
	 * @throws LIXMException 処理中に例外が発生した場合
	 */
	public void shed() throws LIXMException{
	    this.dispatcher.dispath(this.receiver);
	}
}
