package org.lixm.core.model;

import org.lixm.core.common.XMLType;

/**
 * <p>XML宣言をモデル化します。</p>
 * 
 * @author tasogare
 * @version 1.0.1
 */
public class XmlDeclModel extends AbstractModel {

    private String version;
    private String encoding;
    private String standalone;

    public XmlDeclModel(
        String version, String encodeing, String standalone)
    {
        super(XMLType.XML_DECL);

        this.version = version;
        this.encoding = encodeing;
        this.standalone = standalone;
    }

    /**
     * <p>XMLのヴァージョンを取得します。</p>
     * 
     * @return XMLのヴァージョン
     */
    public String getVersion() {
        return version;
    }

    /**
     * <p>XMLのヴァージョンを設定します。</p>
     * 
     * @param version 新しいXMLのヴァージョン
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /**
     * <p>XMLのエンコーディングを取得します。</p>
     * 
     * @return XMLのエンコーディング
     */
    public String getEncoding() {
        return encoding;
    }

    /**
     * <p>XMLのエンコーディングを設定します。</p>
     * 
     * @param encoding 新しいXMLのエンコーディング
     */
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /**
     * <p>XMLのスタンドアロン宣言を取得します。</p>
     * @return XMLのスタンドアロン宣言
     */
    public String getStandalone() {
        return standalone;
    }

    /**
     * <p>XMLのスタンドアロン宣言を設定します。</p>
     * 
     * @param standalone 新しいXMLのスタンドアロン宣言
     */
    public void setStandalone(String standalone) {
        this.standalone = standalone;
    }

    public String toString() {
        return "<?xml " + " version=" + "\"" + getVersion( ) + "\""
            + " encodeing=" + "\"" + getEncoding( ) + "\"" + " standalone="
            + "\"" + getStandalone( ) + "\"" + "?>";
    }

    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }

}
