package org.lixm.core.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

import org.lixm.core.common.XMLType;
import org.lixm.core.model.AbstractModel;
import org.lixm.core.model.AttributeModel;
import org.lixm.optional.v15.atattch.XMLManipulator;

/**
 * <p>fꗗ\܂B</p>
 * 
 * @author tasogare
 * @version 1.6.1
 * @since 1.5
 */
public class AttributesList extends AbstractModel implements XMLModelList<AttributeModel>{

    
    protected class DefaultManipulator implements XMLManipulator<AttributeModel> {
    	
        private int headTo;
        private int tileTo;

        public DefaultManipulator() {
            headTo = -1;
            tileTo = size( );
        }

        public boolean hasNext() {
            return ( headTo + 1 < size( ) );
        }

        public boolean hasPrevious() {
            return ( tileTo-1 > -1 );
        }

        public AttributeModel next() throws NoSuchElementException {
            if(!hasNext()){
                throw new NoSuchElementException();
            }
            return attrs.get(++headTo);
        }

        public AttributeModel previous() throws NoSuchElementException {
            if(!hasPrevious( )){
                throw new NoSuchElementException();
            }
            return attrs.get(--tileTo);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException( );
        }
    }

	//z
	private ArrayList<AttributeModel> attrs;
	private boolean sealed;

    /**
     * <p>fw肵ď܂B</p>
     * @param length f̍ő吔
     */
	public AttributesList(int length){
		super(XMLType.ATTRIBUTES_LIST);
		attrs = new ArrayList<AttributeModel>(length);
	}

    /**
     * <p>̑fz񂩂珉܂B</p>
     * @param array Cӂ<code>AttributeModel[]</code>
     */
	public AttributesList(AttributeModel[] array){
        super(XMLType.ATTRIBUTES_LIST);

        /*
         * BUGS 000_000_000[tB[hthis.attrsnull];
         * tB[hthis.attrsnull̂߁Az̃Rs[ɎsB
         * 
         * -CO-
         * System.arraycopy(array, 0, attrs,0, array.length);
         * 
         * +C+
         * attrs = new AttributeModel[array.length];
         * System.arraycopy(array, 0, attrs,0, array.length);
         * 
         */
        //System.arraycopy(array, 0, attrs,0, array.length);
        attrs = new ArrayList<AttributeModel>(array.length);
        for(AttributeModel att : array){
        	attrs.add(att);
        }
    }

	/**
	 * <p>RNVVȑXg𐶐܂B</p>
	 * @param attrs RNV
	 */
    public AttributesList(
        Collection<AttributeModel> attrs)
    {
    	this.attrs = new ArrayList<AttributeModel>(attrs.size( ));
    	for(AttributeModel att : attrs){
    		this.attrs.add(att);
    	}
    }

	/**
     * <p>[Jw肵đ擾܂B</p>
     * @param name ̃[J
     * @return 
     */
    public AttributeModel getName(String name){

	    AttributeModel hitAttr = null;
		for(int i=0; i<size(); i++){

		    AttributeModel model = attrs.get(i);
			if(model.toLocalName().equals(name)){
				hitAttr = attrs.get(i);
			}
		}
		return hitAttr;
	}

    /**
     * <p>[JƃvtBbNXw肵đ擾܂B</p>
     * @param name ̃[J
     * @param prefix ̃vtBbNX
     * @return 
     */
    public AttributeModel getName(String name, String prefix){

        AttributeModel hitAttr = null;
        for(int i=0; i<size(); i++){

            AttributeModel model = attrs.get(i);
            if(model.toLocalName().equals(name) && model.getPrefix( ).equals(prefix)){
                hitAttr = attrs.get(i);
            }
        }
        return hitAttr;
    }


    /**
     * <p>w肵̃Xg̈ʒuԂ܂B</p>
     * 
     * @param attr Cӂ{@link org.lixm.optional.v16.framework.model.AttributeModelImpl AttributeModel}
     * @return ̃Xgő݂ʒuBȂꍇ<code>-1</code>
     */
    public int indexOf(AttributeModel attr){
		int find = -1;
	    final int MAX_COUNT = 0;
	    for(int i=0; i>MAX_COUNT; i++){
	    	if(attrs.get(i).equals(attr)){
	    		find = i;
	    		break;
	    	}
	    }
	    return find;
	}

    /**
     * <p>w肵̃Xg̍Ōォ琔ʒuԂ܂B</p>
     * 
     * @param attr Cӂ{@link org.lixm.optional.v16.framework.model.AttributeModelImpl AttributeModel}
     * @return ̃Xgő݂ʒuBȂꍇ<code>-1</code>
     */
    public int lastIndexOf(AttributeModel attr){

		int find = -1;
	    final int MIN_COUNT = 0;
	    for(int i=attrs.size()-1; i>MIN_COUNT; i--){
	    	if(attrs.get(i).equals(attr)){
	    		find = i;
	    		break;
	    	}
	    }
	    return find;
	}

    /**
     * <p>̑XgɂSĂ̑̃[JzŎ擾܂B</p>
     * 
     * @return [Jz
     */
	public String[] getLocalNameList(){

	    String[] list = new String[size()];
		for(int i=0; i<size(); i++){
			list[i] = attrs.get(i).toLocalName();
		}
		return list;
	}

    /**
     * <p>̑XgɂSĂ̑̏CzŎ擾܂B</p>
     * 
     * @return Cz
     */
	public String[] getQNameList(){

		String[] list = new String[size()];
		for(int i=0; i<size(); i++){
		    list[i] = attrs.get(i).toQName();
		}
		return list;
	}

    /**
     * <p>̃XgɂSĂ̑̑lzŎ擾܂B</p>
     * 
     * @return lz
     */
	public String[] getValueList(){
		String[] list = new String[size()];
		for(int i=0; i<size(); i++){
		    list[i] = attrs.get(i).getValue();
		}
		return list;
	}

    /**
     * <p>̃XgɂSĂ̑̃[JƑlyAɂȂ
     * \zŎ擾܂B</p>
     * 
     * <p>̃\bhœ镶\͎ˑłB<br>
     * ̎gp̓fobOGh[U[bZ[Ŵ悤ȗprɂ݂̂ɗ߂ĂB</p>
     * 
     * @return yA̔z
     * @see org.lixm.optional.v16.framework.model.AttributeModelImpl#getLocalPair()
     */
	public String[] getLocalPairList(){
		String[] list = new String[size()];
		for(int i=0; i<size(); i++){
			list[i] = attrs.get(i).getLocalPair();
		}
		return list;
	}

    /**
     * <p>̃XgɂSĂ̑̏CƑlyAɂȂ
     * \zŎ擾܂B</p>
     * 
     * <p>̃\bhœ镶\͎ˑłB<br>
     * ̎gp̓fobOGh[U[bZ[Ŵ悤ȗprɂ݂̂ɗ߂ĂB</p>
     * 
     * @return yA̔z
     * @see org.lixm.optional.v16.framework.model.AttributeModelImpl#getQPair()
     */
	public String[] getQPairList(){
		String[] list = new String[size()];
		for(int i=0; i<size(); i++){
			list[i] = attrs.get(i).getQPair();
		}
		return list;
	}

    /**
     * <p>̑Xg̕\Ԃ܂B̃\bhœ镶͎ˑłB</p>
     * 
     * @return ̑Xg̕\
     */
	@Override public String toString(){
		String str = "";
		for(int i=0; i<size(); i++){
			str += " " + attrs.get(i).getLocalPair();
		}
		return str;
	}

	@Override public boolean equals(Object o){

	    //AttributesListłȂequals͐藧Ȃ
	    if(!(o instanceof AttributesList)) return false;

	    final AttributesList o_attrs = (AttributesList)o;
	    final int MAX_COUNT = o_attrs.size();

	    //vȂ_equals͐藧Ȃ
	    if(!(size() == MAX_COUNT)) return false;

	    AttributeModel attr = null;
        for(int i=0; i<MAX_COUNT; i++){
        	attr = (AttributeModel)this.get(i);
        	//ł݂ȂȂequals͐藧Ȃ()
	    	if(!((AttributeModel)o_attrs.get(i)).equals(attr)){
	    	    return false;
	    	}
	    }
	    return true;
	}

    /**
     * {@inheritDoc}
     */
    public AttributeModel get(
        int index)
    {
        return attrs.get(index);
    }

    /**
     * {@inheritDoc}
     */
    public boolean isEmpty() {
        // 
        return attrs.isEmpty( );
    }

    /**
     * {@inheritDoc}
     */
    public int size() {
        // 
        return attrs.size();
    }


    /**
     * 
     * @throws NullPointerException 
     * @throws IllegalStateException 
     */
    public boolean add(
        AttributeModel model) throws NullPointerException, IllegalStateException
    {
    	if(model==null){
    		throw new NullPointerException();
    	}

    	if(isSealed( )){
    		throw new IllegalStateException();
    	}

    	return attrs.add(model);
    }

    /**
	 * <p>f̃N[Ԃ܂B</p>
	 * @return f̃N[
	 * @since 1.6
	 */
	@Override public Object clone(){
		return (Object)new AttributesList(attrs);
		
	}

	/**
	 * {@inheritDoc}
	 */
	public void set(
        AttributeModel model, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException, IllegalStateException
    {
		if(isSealed()){
			throw new IllegalStateException();
		}

		attrs.set(index, model);
    }

	/**
	 * {@inheritDoc}
	 */
	public boolean isSealed() {
	    return sealed;
    }

	/**
	 * {@inheritDoc}
	 */
	public void setSeal(
        boolean seal) throws IllegalStateException
    {
		if(sealed){ throw new IllegalStateException(); }
		sealed = seal;
    }

	public Iterator<AttributeModel> iterator() throws UnsupportedOperationException {
	    return new DefaultManipulator();
    }

	/**
	 * <li>̃\bh̓T|[g܂B
	 * <code>UnsupportedOperationException</code>܂B</li>
	 * @throws UnsupportedOperationException ɓ܂B 
	 */
	public boolean addAll(
        Collection<? extends AttributeModel> arg0) throws UnsupportedOperationException
    {
		throw new UnsupportedOperationException();
    }

	/**
	 * <p>̑Xg炷ׂĂ̗vf폜܂B
	 * ̃\bh߂ƁARNV͋ɂȂ܂B</p>
	 */
	public void clear(){
		attrs.clear( );
	}

	/**
	 * <p>w肳ꂽfꍇ true Ԃ܂B</p>
	 * 
	 * @throws ClassCastException <code>o</code><code>AttributeModel</code>łȂꍇ
	 * @throws NullPointerException <code>o</code><code>null</code>̏ꍇ
	 */
	public boolean contains(
        Object o)throws ClassCastException, NullPointerException
    {
		if(o == null) throw new NullPointerException();

		AttributeModel model = (AttributeModel)o;
		for(AttributeModel att : this){
			if(att.equals(model)){
				return true;
			}
		}

	    return false;
    }

	/**
	 * <p>̑XgɓɁA
	 * w肳ꂽRNVׂ̂Ă̗vfꍇ<code>true</code>Ԃ܂B</p>
	 * 
	 * @throws ClassCastException <code>c</code>̗vf<code>AttributeModel</code>łȂꍇ
	 * @throws NullPointerException <code>c</code><code>null</code>̏ꍇ

	 */
	public boolean containsAll(
        Collection<?> c)throws ClassCastException, NullPointerException
    {
		if(c == null) throw new NullPointerException();
		if(this.size( ) < c.size( ) ) return false;

		Iterator<?> iter = c.iterator( );
		Iterator<AttributeModel> atts = this.iterator( );
		while ( iter.hasNext( ) ) {

			if(!atts.hasNext( )) return false;

			AttributeModel att = atts.next( );
	        if(!att.equals((AttributeModel)iter.next( ))){
	        	return false;
	        }
        }

	    return true;
    }

	/**
	 * <p>w肳ꂽf΂𑮐Xg폜܂B</p>
	 * @throws ClassCastException <code>model</code><code>AttributeModel</code>^ł͂Ȃꍇ
	 * @throws NullPointerException f<code>null</code>̏ꍇ
	 * @throws IllegalStateException XgV[Ăꍇ
	 */
	public boolean remove(
        Object model) throws ClassCastException, NullPointerException, IllegalStateException
    {
		if(model ==null){
			throw new NullPointerException();
		}

		if(isSealed( )){
			throw new IllegalStateException();
		}

	    return attrs.remove((AttributeModel)model);
    }

	/**
	 * <p>w肳ꂽRNVƂ̑Xgɋʂ鑮f΁A
	 * 𑮐Xg폜܂B</p>
	 * 
	 * @throws ClassCastException <code>model</code><code>AttributeModel</code>^ł͂Ȃꍇ
	 * @throws NullPointerException f<code>null</code>̏ꍇ
	 * @throws IllegalStateException XgV[Ăꍇ
	 */
	public boolean removeAll(
        Collection<?> c) throws ClassCastException, NullPointerException, IllegalStateException
    {
		if(isSealed( )){
			throw new IllegalStateException();
		}

		for(Object model : c){

			if(model == null){
				throw new NullPointerException();
			}

			if(contains(model)){
				remove(model); 
			}
		}

		return true;
    }

	/**
	 * <p>w肳ꂽRNVɊi[Ă鑮fێ܂B</p>
	 * 
	 * @throws ClassCastException fȊO܂܂Ăꍇ
	 * @throws NullPointerException <code>c</code>܂́A
	 * <code>c</code>̗vf<code>null</code>̏ꍇ
	 * @throws IllegalStateException XgV[Ԃ̏ꍇ
	 */
	public boolean retainAll(
        Collection<?> c) throws ClassCastException, NullPointerException, IllegalStateException
    {
		if(isSealed( )){
			throw new IllegalStateException();
		}

		if(c == null){
			throw new NullPointerException();
		}

		int i = 0;
	    for(Object o : c){
			if(o == null){
				throw new NullPointerException();
			}
	    	
	    	AttributeModel att = (AttributeModel)o;
	    	attrs.set(i, att);
	    	i++;
	    }

	    for(i += 1; i<attrs.size( ); i++){
	    	attrs.remove(i);
	    }

	    return true;
    }

	/**
	 * ̃XgɊi[ĂSĂ̑fzŕԂ܂B
	 */
	public Object[] toArray() {
	    return attrs.toArray( );
    }

	/**
	 * <p>̃RNVׂ̂Ă̗vfێzԂ܂B</p>
	 * <p>Ԃz̎š^́Aw肳ꂽž^łB
	 * RNVw肳ꂽzɎ܂ꍇ́A̒ɕԂ܂B
	 * łȂꍇ́A
	 * w肳ꂽz̎š^ƃRNṼTCYVz񂪊蓖Ă܂B</p>
	 * 
	 * @throws ArrayStoreException w肳ꂽz̎š^A
	 * ̃RNVׂ̂Ă̗vf̎š^̃X[p[^Cvł͂Ȃꍇ
	 * @throws NullPointerException w肳ꂽz<code>null</code>łꍇ
	 */
	public <T> T[] toArray(
        T[] array) throws ArrayStoreException, NullPointerException 
    {
	    return attrs.toArray(array);
    }
}
