package org.pigeonblood.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;

import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.common.XMLType;
import org.lixm.core.model.AbstractModel;
import org.pigeonblood.impl.core.list.SimpleDocumentList;
import org.pigeonblood.impl.core.modelizer.PushXMLModelizer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class Test1 {

    private static final int RUNTIME_ERR_CODE = 1;

    private static File inputXML;
    private static SAXParser parser;
    private static SAXSource srcXML;

    private static PushXMLModelizer modelizer;

    /*
     * p[T̐ݒOvpeBt@C
     */
    private static Properties xmlConf;

    private static final String XMLCONF_VALIDATING = "test.xml.sax.features.validation";
    private static final String XMLCONF_NAMESPACE_AWARE = "test.xml.sax.features.namespace";

    /**
     * @param args
     */
    public static void main(
        String[] args)
    {
        if (!analizeArgs(args)) {
            cryErr( );
        }

        createSource( );

        if (srcXML == null) {
            cryErr( );
        }

        createModelizer( );

        printXMLList( );
    }

    /**
     * s̉
     * @param args
     * @return s̉͂ɐǂ
     */
    protected static synchronized boolean analizeArgs(
        String[] args)
    {

        boolean resualt = false;
        if (args.length != 2) {
            usage( );
            resualt = false;
        } else {
            inputXML = new File(args[0]);

            if (analizeProperties(args[1])) {
                resualt = true;
            } else {
                resualt = false;
            }
        }

        return resualt;
    }

    protected static SAXParser newParser() throws ParserConfigurationException,
        SAXException
    {

        SAXParserFactory xrf = SAXParserFactory.newInstance( );
        boolean namespaceAware = Boolean.valueOf(xmlConf
            .getProperty(XMLCONF_NAMESPACE_AWARE));

        /*
         * TODO ݁Aϐ validation ͗pĂȂ
         */
        @SuppressWarnings("unused") boolean validation = Boolean.valueOf(xmlConf
            .getProperty(XMLCONF_VALIDATING));

        xrf.setNamespaceAware(namespaceAware);
        //xrf.setValidating(validation);

        return xrf.newSAXParser( );
    }

    protected static void parserConfiguration() {
        if (parser == null) {
            throw new AssertionError("SAXp[T null łB");
        }

        if (modelizer == null) {
            throw new AssertionError("fCU null łB");
        }

        XMLReader r = null;
        try {
            r = parser.getXMLReader( );
        } catch (SAXException e) {
            e.printStackTrace( );
            cryErr( );
        }

        PushXMLModelizer.DefaultModelizeResolver resolver = modelizer.new DefaultModelizeResolver( );
        r.setContentHandler(resolver);

        try {
            r.setProperty("http://xml.org/sax/properties/lexical-handler",
                resolver);
        } catch (SAXNotRecognizedException e) {
            e.printStackTrace( );
            cryErr( );
        } catch (SAXNotSupportedException e) {
            printMessages("LVJnh͐ݒ肳܂łB");
        }

        printMessages(
            "", "SAXp[T̋@\",
            "+\t\t\t\t\t\t\t\t\t\t+",
            "OԂ̔F : " + parser.isNamespaceAware( ),
            "Ó؂̗L : " + parser.isValidating( ),
            "+\t\t\t\t\t\t\t\t\t\t+", "");
    }

    protected final static void usage() {
        System.out.println("Usage:");
        System.out.println("\t\tjava Test input_xml_file xml_config_file");
    }

    private static synchronized boolean analizeProperties(
        String fileName)
    {

        boolean resualt = false;
        if (fileName.endsWith(".properties")) {
            xmlConf = new Properties( );

            try {
                xmlConf.load(new FileReader(fileName));
            } catch (FileNotFoundException e) {
                System.err.println("vpeBt@C܂B");
                usage( );
                resualt = false;
                return resualt;
            } catch (IOException e) {
                System.err.println("vpeBt@C̓ǂݍ݂Ɏs܂B");
                usage( );
                resualt = false;
                return resualt;
            }

            resualt = true;
        } else {
            resualt = false;
            System.err.println("vpeBt@C̊gq 'properties' łȂ΂܂B");
            usage( );
        }

        return resualt;
    }

    private static synchronized void createModelizer() {
        modelizer = (PushXMLModelizer) PushXMLModelizer.newInstance(srcXML,
            new SimpleDocumentList(10000));

        //        PushXMLModelizer.DefaultModelizeResolver resolver = modelizer.newResolver( );
        //        srcXML.getXMLReader( ).setContentHandler(resolver);
        parserConfiguration( );
    }

    private static synchronized void createSource() {
        try {
            parser = newParser( );
        } catch (ParserConfigurationException e) {
            e.printStackTrace( );
        } catch (SAXException e) {
            e.printStackTrace( );
        }

        //        parserConfiguration();

        try {
            srcXML = new SAXSource(parser.getXMLReader( ), new InputSource(
                new FileReader(inputXML)));
        } catch (FileNotFoundException e) {
            e.printStackTrace( );
        } catch (SAXException e) {
            e.printStackTrace( );
        }
    }

    private static void cryErr(
        String... messages)
    {

        for (String mess : messages) {
            System.err.println(mess);
        }

        System.err
            .println("--------------------------------------------------------------------------------");
        System.err.println( );
        System.err.println("vOsɃG[܂B");
        System.err.println("vOI܂B");
        System.err.println( );

        System.exit(RUNTIME_ERR_CODE);
    }

    private static void printMessages(
        Object... messages) throws IllegalArgumentException
    {
        if (messages == null || messages.length == 0) {
            throw new IllegalArgumentException(
                "ψ messages ͂PȏObject^łȂ΂܂B");
        }

        for (Object mess : messages) {
            System.out.println(mess);
        }
    }

    private static void printXMLList() {
        try {
            modelizer.modelize( );
        } catch (LIXMPhaseException e) {
            e.getException( ).printStackTrace( );
            e.printStackTrace( );
            cryErr(e.getMessage( ));
        }

        SimpleDocumentList list = (SimpleDocumentList) modelizer.getList( );

        if (list == null || list.size( ) == 0) {
            cryErr("fXgłB");
        }

        System.out.println("fXg̃TCY : " + String.valueOf(list.size( ) - 1));

        try {
            for (AbstractModel model : list) {
                if (!( model.matchTypes(XMLType.START_DOCUMENT) || model
                    .matchTypes(XMLType.END_DOCUMENT) ))
                {
                    System.out.print(model);
                } else {
                    printMessages("\n",
                        ( model.matchTypes(XMLType.START_DOCUMENT)
                        ? "̎n܂\n"
                        + "--------------------------------------------------------------------------------\n"
                        :  "--------------------------------------------------------------------------------\n"
                        + "̏I" ), "");
                }
            }
        } catch (RuntimeException e) {
            e.printStackTrace( );
        }
    }
}
