package org.pigeonblood.impl.optional.cnif;

import java.util.NoSuchElementException;

import org.lixm.core.common.LIXMException;
import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.model.AbstractModel;
import org.lixm.optional.v15.atattch.XMLReceiver;
import org.lixm.optional.v16.framework.cnif.XMLCrawler;
import org.pigeonblood.impl.core.list.SimpleDocumentList;

/**
 * <p>XMLN[[̒PȒێłB</p>
 * 
 * <p>{@link #accept(AbstractModel)}A
 * VȃXgŎ󂯓郂fI܂B</p>
 * 
 * <p>Xg̃N[Jnɂ{@link #dispath()}Ăяo܂B</p>
 * <p>̎ł̓N[͏ւƍs܂A
 * {@linkplain #dispath()}{@link #hasPrevious()}A
 * {@link #previous()}𗘗p悤ɍĎ΋tւƃN[鎖\łB</p>
 * 
 * <p>{@linkplain #dispath()}̎͂̂悤ɂȂĂ܂B</p>
 * 
 * <pre class="code">
 * 	public void dispath() throws LIXMException {
 * 		if(indexer==null){
 * 			throw new LIXMException(new NullPointerException());
 * 		}
 * 
 * 		AbstractModel model=null;
 * 		while(this.hasNext( )){
 * 
 * 			model = this.next( );
 * 			if(accept(model)){
 * 				indexer.receive(model);
 * 			}
 * 		}
 * 	}
 * </pre>
 * 
 * @author tasogare
 *
 */
public abstract class AbstractXMLCrawler implements XMLCrawler {


	private SimpleDocumentList list;
	private AbstractXMLIndexer indexer;

	private int headTo;
    private int tileTo;

//    public AbstractXMLCrawler(SimpleDocumentList list) {
//        this.list = list;
//    	headTo = -1;
//        tileTo = list.size( );
//    }

    /**
     * @param list N[Ώۂ̃Xgł
     * @param indexer CfNTł
     */
    public AbstractXMLCrawler(SimpleDocumentList list, AbstractXMLIndexer indexer) {
        this.list = list;
        this.indexer = indexer;
    	headTo = -1;
        tileTo = list.size( );
    }

    /**
     * {@inheritDoc}
     */
    public abstract boolean accept(AbstractModel model) throws LIXMPhaseException;

    /**
     * {@inheritDoc}
     */
    public boolean hasNext() {
        return ( headTo + 1 < list.size( ) );
    }

    /**
     * {@inheritDoc}
     */
    public boolean hasPrevious() {
        return ( tileTo-1 > -1 );
    }

    /**
     * {@inheritDoc}
     */
    public AbstractModel next() throws NoSuchElementException {
        if(!hasNext()){
            throw new NoSuchElementException();
        }
        
        return list.get(++headTo);
    }

    /**
     * {@inheritDoc}
     */
    public AbstractModel previous() throws NoSuchElementException {
        if(!hasPrevious( )){
            throw new NoSuchElementException();
        }

        return list.get(--tileTo);
    }

	/**
	 * <p>̃\bh̓T|[g܂B
	 * KA<code>UnsupportedOperationException</code>܂B</p>
	 */
    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException( );
    }

    /**
     * <p>CfNTɃffBXpb`܂B<br>
     * ̎A{@link #accept(AbstractModel)}ɂ
     * f󂯓邩ǂI܂B</p>
     * 
     * @throws LIXMException CfNT<code>null</code>̂ƂA
     * NullPointerExceptionƋɓ܂B
     */
	public void dispath() throws LIXMException {
		if(indexer==null){
			throw new LIXMException(new NullPointerException());
		}

		AbstractModel model=null;
		while(this.hasNext( )){

			model = this.next( );
			if(accept(model)){
				indexer.receive(model);
			}
		}
	}

	/**
	 * <p>̃\bh̓T|[g܂B
	 * KA<code>UnsupportedOperationException</code>܂B</p>
	 */
	public void dispath(
	    XMLReceiver receiver) throws UnsupportedOperationException
	{
//		while(this.hasNext( )){
//			receiver.receive(this.next( ));
//		}
		throw new UnsupportedOperationException();
	}

}
