package org.pigeonblood.impl.core.modelizer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.ArrayList;

import javax.xml.transform.sax.SAXSource;

import org.lixm.core.common.LIXMPhaseException;
import org.lixm.core.list.AttributesList;
import org.lixm.core.list.XMLDocumentList;
import org.lixm.core.model.AbstractModel;
import org.lixm.core.model.AttributeModel;
import org.lixm.optional.v15.atattch.LIXMConfigurationException;
import org.lixm.optional.v16.framework.model.AttributeModelImpl;
import org.lixm.optional.v16.framework.model.CharactersModelImpl;
import org.lixm.optional.v16.framework.model.CommentModelImpl;
import org.lixm.optional.v16.framework.model.ElementModelImpl;
import org.lixm.optional.v16.framework.model.EndCdataModelImpl;
import org.lixm.optional.v16.framework.model.EndDocumentModelImpl;
import org.lixm.optional.v16.framework.model.EndTagModelImpl;
import org.lixm.optional.v16.framework.model.ProcessingInstructionModelImpl;
import org.lixm.optional.v16.framework.model.StartCdataModelImpl;
import org.lixm.optional.v16.framework.model.StartDocumentModelImpl;
import org.lixm.optional.v16.framework.model.StartTagModelImpl;
import org.pigeonblood.impl.core.configuration.PigeonbloodXMLConfiguration;
import org.pigeonblood.impl.core.list.SimpleDocumentList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

/**
 * <p>SAX𗘗pXMLfCY܂B</p>
 * 
 * @author tasogare
 *
 */
public class PushXMLModelizer extends AbstractXMLModelizer<SAXSource> {

	/**
	 * TODO \ɉfCY
	 * @author tasogare
	 *
	 */
	public class DefaultModelizeResolver implements ContentHandler,
	                                LexicalHandler
	{

		//obt@Ǘ߂ǂ̂ArrayListɔC
		ArrayList<AbstractModel> models;

		public DefaultModelizeResolver() {
			models = new ArrayList<AbstractModel>(100);
		}

		public void characters(
		    char[] chars, int start, int length) throws SAXException
		{
			models.add(new CharactersModelImpl(new String(chars, start, length)));
		}

		public void comment(
		    char[] ch, int start, int length) throws SAXException
		{
			/*
			 * BUGS 000_000_000[RtBMAݒ肳ĂȂꍇ̏Y]
			 * RtBMAݒ肳ĂȂꍇ̓RgfCYĒɖ߂悤ɂB
			 */
			if ( getConfigure( ) == null ) {
				models.add(new CommentModelImpl(new String(ch, start, length)));
				return;
			}

			try {
				if ( !getConfigure( ).getFeature(
				    PigeonbloodXMLConfiguration.IGNORE_COMMENTS) )
				{
					models.add(new CommentModelImpl(new String(ch, start, length)));
				}
			} catch ( LIXMConfigurationException e ) {

				/*
				 * PigeonbloodXMLConfigurationIGNORE_COMMENTSF̂
				 * LIXMConfigurationException鎖͂肦ȂB
				 * āAA[T[VB
				 */
				throw new AssertionError(e);
			}
		}

		public void endCDATA() throws SAXException {
			models.add(new EndCdataModelImpl( ));
		}

		public void endDocument() throws SAXException {
			models.add(new EndDocumentModelImpl(null, source.getSystemId( )));
			( (SimpleDocumentList) list ).addAll(models);
		}

		public void endDTD() throws SAXException {}

		public void endElement(
		    String uri, String localName, String qName) throws SAXException
		{

			boolean outColon = qName.indexOf(':') == -1;
			String pref = outColon ? "" : qName
			    .substring(0, qName.indexOf(':'));
			String name;

			if ( localName.equals("") || localName == null ) {

				//vtBbNꍇ
				if ( !outColon ) {
					name = qName.substring(qName.indexOf(':') + 1);
				}
				//vtBbNȂꍇ
				else {
					name = qName;
				}
			} else {
				name = localName;
			}

			models.add(new EndTagModelImpl(new ElementModelImpl(name, pref, uri)));
		}

		public void endEntity(
		    String arg0) throws SAXException
		{}

		public void endPrefixMapping(
		    String arg0) throws SAXException
		{}

		public void ignorableWhitespace(
		    char[] chars, int start, int length) throws SAXException
		{
			models.add(new CharactersModelImpl(new String(chars, start, length)));
		}

		public void processingInstruction(
		    String target, String data) throws SAXException
		{
			//xml-style PIɂ͑ΉȂ
			models.add(new ProcessingInstructionModelImpl(target, data));
		}

		public void setDocumentLocator(
		    Locator arg0)
		{}

		public void skippedEntity(
		    String arg0) throws SAXException
		{}

		public void startCDATA() throws SAXException {
			models.add(new StartCdataModelImpl( ));
		}

		public void startDocument() throws SAXException {
			models.add(new StartDocumentModelImpl(null, source.getSystemId( )));
		}

		public void startDTD(
		    String arg0, String arg1, String arg2) throws SAXException
		{}

		public void startElement(
		    String uri, String localName, String qName, Attributes atts)
		    throws SAXException
		{
			final int MAX_SIZE = atts.getLength( );
			AttributeModel[] attrs = new AttributeModel[MAX_SIZE];

			boolean outColon = false;
			for ( int i = 0; i < MAX_SIZE; i++ ) {
				String qAName = atts.getQName(i);
				outColon = qAName.indexOf(':') == -1;
				String aPref = outColon /*qAName.equals("")*/? "" : qAName
				    .substring(0, qAName.indexOf(':'));

				attrs[i] = new AttributeModelImpl(atts.getLocalName(i), atts
				    .getValue(i), aPref, atts.getURI(i));
			}

			outColon = qName.indexOf(':') == -1;
			String pref = outColon ? "" : qName
			    .substring(0, qName.indexOf(':'));
			String name;

			if ( localName.equals("") || localName == null ) {

				//vtBbNꍇ
				if ( !outColon ) {
					name = qName.substring(qName.indexOf(':') + 1);
				}
				//vtBbNȂꍇ
				else {
					name = qName;
				}
			} else {
				name = localName;
			}

			models.add(new StartTagModelImpl(new ElementModelImpl(name, pref, uri),
			    new AttributesList(attrs)));
		}

		public void startEntity(
		    String arg0) throws SAXException
		{}

		public void startPrefixMapping(
		    String arg0, String arg1) throws SAXException
		{}
	}

	/**
	 * <p>̃fCU𐶐t@NgłBϊ\[Xw肵܂B</p>
	 * 
	 * @param source ϊ\[X
	 * @return ̃fCŨCX^X
	 */
	public static AbstractXMLModelizer<SAXSource> newInstance(
	    SAXSource source)
	{
		return new PushXMLModelizer(source);
	}

	//    protected SAXSource source;

	/**
	 * <p>̃fCU𐶐t@NgłB
	 * ϊ\[Xƕϊʂi[郊Xgw肵܂B</p>
	 * 
	 * @param source ϊ\[X
	 * @param list ϊʂi[郂fXg
	 * @return ̃fCŨCX^X
	 */
	public static AbstractXMLModelizer<SAXSource> newInstance(
	    SAXSource source, XMLDocumentList<AbstractModel> list)
	{
		return new PushXMLModelizer(source, list);
	}

	/**
	 * <p>ی삳ꂽRXgN^łB<p>
	 * @param source fCŸׂ̕ϊ\[X
	 */
	protected PushXMLModelizer(
	    SAXSource source)
	{
		super(source);
	}

	/**
	 * <p>ی삳ꂽRXgN^łB<p>
	 * @param source fCŸׂ̕ϊ\[X
	 * @param list ϊʂi[郂fXg
	 */
	protected PushXMLModelizer(
	    SAXSource source, XMLDocumentList<AbstractModel> list)
	{
		super(source);
		this.setList(list);
	}

	/**
	 * {@inheritDoc}
	 */
	public void modelize() throws LIXMPhaseException {
		modelizing = true;

		if ( this.list == null ) {
			modelizing = false;
			throw new LIXMPhaseException("fCYs悤Ƃ܂Xg֘AtĂ܂",
			    LIXMPhaseException.PHASE_MODELAIZE);
		}

		XMLReader parser = source.getXMLReader( );

		if ( parser == null ) {
			modelizing = false;
			throw new LIXMPhaseException("fCYs悤Ƃ܂SAXp[T݂܂",
			    LIXMPhaseException.PHASE_MODELAIZE);
		}

		if ( parser.getContentHandler( ) == null ) {
			modelizing = false;
			throw new LIXMPhaseException("fCYs悤Ƃ܂SAXnh݂܂",
			    LIXMPhaseException.PHASE_MODELAIZE);
		}

		try {
			parser.parse(source.getInputSource( ));
		} catch ( Exception e ) {
			modelizing = false;
			throw new LIXMPhaseException("fCYsɗO܂", e,
			    LIXMPhaseException.PHASE_MODELAIZE);
		}

		modelizing = false;
	}

	private DefaultModelizeResolver newResolver() {
		return new DefaultModelizeResolver( );
	}

	/**
	 * {@inheritDoc}
	 */
	public void modelize(
	    String file) throws LIXMPhaseException
	{
		try {
	        source.setInputSource(new InputSource(new FileReader(new File(file))));
        } catch ( FileNotFoundException e ) {
        	throw new LIXMPhaseException(e, LIXMPhaseException.PHASE_MODELAIZE);
        }
        modelize( );
	}

}
