package org.pigeonblood.impl.core.configuration;

import java.util.HashMap;

import org.lixm.optional.v15.atattch.LIXMConfigurationException;
import org.lixm.optional.v15.atattch.LIXMConfigurationSupport;
import org.pigeonblood.impl.core.configuration.properties.PIConfigurationProperty;

/**
 * <p>PigeonbloodŗL̍\T|[g<code>LIXMConfigurationSupport</code>łB</p>
 * 
 * @author tasogare
 *
 */
public class PigeonbloodXMLConfiguration implements LIXMConfigurationSupport {

    public static final String CONFIG_FEATURE_BASE = "http://www.pigeonblood.org/features/";
    public static final String CONFIG_PROPERTIES_BASE = "http://www.pigeonblood.org/properties/";

    /**
     * RgfCY̑ΏۂO܂B
     */
    public static final String IGNORE_COMMENTS = CONFIG_FEATURE_BASE
        + "ignore_comments";
    private boolean enabledIgnoreComments;

    /**
     * m[}CYꂽXMLfCY܂B
     */
    public static final String NORMALIZED_FORM = CONFIG_FEATURE_BASE
        + "normalized_form";
    private boolean enabledNormalizedForm;

    /**
     * LmjJCYꂽXMLfCY܂B
     * TODO ݁A̋@\tO͖
     */
    public static final String CANONICALIZED_FORM = CONFIG_FEATURE_BASE
        + "canonicalized_form";
    @SuppressWarnings("unused") private boolean enabledCanonicalizedForm;

    /*
     * TODO PigeonbloodŗLvpeB܂܂ĂȂ̂ŁA֘ASł͂Ȃ
     */
    private final HashMap<String, Object> properties;

    public PigeonbloodXMLConfiguration() {
        properties = new HashMap<String, Object>( );
        initProperties( );
    }

    /**
     * ŏĂ\͔F
     */
    private final void initProperties() {
        properties.put(PIConfigurationProperty.KEY, null);
    }

    /**
     * <p>@\Lǂׂ܂B</p>
     * 
     * @return w肳ꂽ@\L̏ꍇ<code>true</code>B
     */
    public boolean getFeature(
        String feature) throws LIXMConfigurationException
    {
        if (feature.equals(IGNORE_COMMENTS)) {
            return enabledIgnoreComments;
        } else if (feature.equals(NORMALIZED_FORM)) {
            return enabledNormalizedForm;
        } else {
            throw new LIXMConfigurationException("T|[gĂȂ@\̏Ԃ擾悤Ƃ܂");
        }
    }

    /**
     * <p>T|[gĂSĂ̋@\tOԂ܂B</p>
     * 
     * @return T|[gĂSĂ̋@\tOi[ꂽz
     */
    public String[] getFeatureSupports() {
        return new String[] { IGNORE_COMMENTS, NORMALIZED_FORM };
    }

    /**
     * <p>̍\擾܂B</p>
     * 
     * <p>{@link #getPropertySupports()}Ԃz̒ɓtO݂A
     * ̃\bh<code>null</code>ԂꍇA͖ݒ肳Ă܂B</p>
     * 
     * @return ̍\tOɊ֘Atꂽ
     * @throws LIXMConfigurationException T|[gĂȂ擾悤ƂƂ
     */
    public Object getProperty(
        String key) throws LIXMConfigurationException
    {

        Object prop = null;
        if (properties.containsKey(key)) {
            prop = properties.get(key);
        } else {
            new LIXMConfigurationException("T|[gĂȂ擾悤Ƃ܂");
        }
        return prop;
    }

    /**
     * <p>̍\SĂ̓tO擾܂B</p>
     * @return T|[gĂSĂ̓tOi[ꂽz
     */
    public String[] getPropertySupports() {
        return ( properties.keySet( ) ).toArray(new String[0]);
    }

    /**
     * <p>\̋@\Lɂ܂B</p>
     */
    public void setFeature(
        String feature, boolean enabled) throws LIXMConfigurationException
    {
        if (feature.equals(IGNORE_COMMENTS)) {
            enabledIgnoreComments = enabled;
        } else if (feature.equals(NORMALIZED_FORM)) {
            enabledNormalizedForm = enabled;
        } else {
            throw new LIXMConfigurationException("T|[gĂȂ@\Lɂ悤Ƃ܂");
        }
    }

    /**
     * <p>\̓ݒ肵܂B</p>
     * 
     * @throws LIXMConfigurationException T|[gĂȂݒ肵悤ƂƂ
     */
    public void setProperty(
        String key, Object property) throws LIXMConfigurationException
    {
        if (properties.containsKey(key)) {
            properties.put(key, property);
        } else {
            new LIXMConfigurationException("T|[gĂȂݒ肵悤Ƃ܂");
        }
    }

}
