package org.lixm.core.model;

import org.lixm.core.common.XMLType;



/**
 * <p>コメントをモデル化します。</p>
 * @author tasogare
 * @version 1.0M1
 */
public class CommentModel extends AbstractModel {

    private String text;

    public CommentModel(
        String text)
    {
        super(XMLType.COMMENT);
        this.text = text;
    }

    public String getText() {
        return text;
    }

    public String toString() {

        String textAsString = text/* "" */;

        String str = "<!-- " + textAsString + " -->";
        return str;
    }

    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }
}
