package org.lixm.core.model;

import org.lixm.core.common.XMLType;

/**
 * <p>XML宣言をモデル化します。</p>
 * 
 * @author tasogare
 * @version 1.0M1
 */
public class XmlDeclModel extends AbstractModel {

    private String version;
    private String encoding;
    private String standalone;

    public XmlDeclModel(
        String version, String encodeing, String standalone)
    {
        super(XMLType.XML_DECL);

        this.version = version;
        this.encoding = encodeing;
        this.standalone = standalone;
    }

    public String getVersion() {
        return version;
    }

    public String getEncoding() {
        return encoding;
    }

    public String getStandalone() {
        return standalone;
    }

    public String toString() {
        return "<?xml " + " version=" + "\"" + getVersion( ) + "\""
            + " encodeing=" + "\"" + getEncoding( ) + "\"" + " standalone="
            + "\"" + getStandalone( ) + "\"" + "?>";
    }

    public boolean equals(
        Object o)
    {
        if (!super.equals(o)) return false;
        return ( this.toString( ) == o.toString( ) );
    }

}
