/**
 * 
 */
package org.lixm.core.common;

import java.io.InputStream;
import java.io.Reader;

/**
 * <p>XML文章ソースを表します。</p>
 * 
 * @author tasogare
 * @version 1.0M1
 */

public class InputSource {

    private String      publicId;
    private String      systemId;
    private InputStream byteStream;
    private String      encoding;
    private Reader      characterStream;

    public InputSource() {}

    /**
     * 指定したシステム識別子で初期化します。
     * @param systemId 設定するシステム識別子
     */
    public InputSource(
        String systemId)
    {
        setSystemId(systemId);
    }

    /**
     * 指定したバイトストリームで初期化します。
     * @param byteStream 設定するバイトストリーム
     */
    public InputSource(
        InputStream byteStream)
    {
        setByteStream(byteStream);
    }

    /**
     * 指定した文字ストリームで初期化します。
     * @param characterStream 設定する文字ストリーム
     */
    public InputSource(
        Reader characterStream)
    {
        setCharacterStream(characterStream);
    }

    /**
     * 公開識別子を設定します。
     * @param publicId 設定する公開識別子です
     */
    public void setPublicId(
        String publicId)
    {
        this.publicId = publicId;
    }

    /**
     * k公開識別子を取得します。
     * @return 公開識別子が返ります
     */
    public String getPublicId() {
        return publicId;
    }

    /**
     * システム識別子を設定します。
     * @param systemId 設定するシステム識別子です
     */
    public void setSystemId(
        String systemId)
    {
        this.systemId = systemId;
    }

    /**
     * システム識別子を取得します。
     * @return システム識別子が返ります
     */
    public String getSystemId() {
        return systemId;
    }

    /**
     * <code>InputSource</code>にバイトストリームを関連付けます。
     * @param byteStream 関連付けるバイトストリーム
     */
    public void setByteStream(
        InputStream byteStream)
    {
        this.byteStream = byteStream;
    }

    /**
     * 関連付けられたバイトストリームを取得します。
     * @return 関連付けられたバイトストリーム
     */
    public InputStream getByteStream() {
        return byteStream;
    }

    /**
     * <p>文字エンコーディングを設定します。
     * <code>InputSource</code>に
     * 文字エンコーディングを設定したからといって
     * ストリームを設定された文字エンコーディングに変換する
     * わけではありません。</p>
     * 
     * @param encoding 設定する文字エンコーディング
     */
    public void setEncoding(
        String encoding)
    {
        this.encoding = encoding;
    }

    /**
     * 文字エンコーディングを取得します。
     * @return 設定された文字エンコーディング
     */
    public String getEncoding() {
        return encoding;
    }

    /**
     * <code>InputSource</code>に文字ストリームを関連付けます。
     * @param characterStream 関連付ける文字ストリーム
     */
    public void setCharacterStream(
        Reader characterStream)
    {
        this.characterStream = characterStream;
    }

    /**
     * 関連付けられた文字ストリームを取得します
     * @return 関連付けられた文字ストリーム
     */
    public Reader getCharacterStream() {
        return characterStream;
    }
}