package cornflower.v10.test.canvas;

import java.util.Date;

import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

import org.lixm.core.common.XMLModelizer;
import org.lixm.core.list.XMLCursor;
import org.lixm.core.list.XMLModelList;
import org.lixm.core.model.AbstractModel;



public class Test1Canvas extends BaseCanvas implements Runnable {

    private XMLModelList  list;
    private XMLCursor     cur;
    private AbstractModel model;

    private long  startedTime;
	Thread t;

    // private Runnable blinker;

    public Test1Canvas(
        MIDlet owner, XMLModelizer tok, boolean suppressKeyEvents)
    {
        // TODO �����������ꂽ�R���X�g���N�^�[�E�X�^�u
        super(owner, tok, suppressKeyEvents);

        this.owner = owner;
        this.tok = tok;
        list = tok.getList( );
        cur = list.getCursor( );
        model = null;
    }

    public void renderCanvas() {
        startTimeAttack( );
        renderXML(getGraphics( ));
    }

    public void startTimeAttack() {
        setSuspended(true);
        cur.setIndex(0);
        startedTime = ( new Date( ) ).getTime( );
        setSuspended(false);
    }

    protected void renderXML(
        Graphics g)
    {

        // Thread thisThread = Thread.currentThread();
        while (t != null) {
            while (cur.hasNext( )) {

                renderSleepOrWait( );

                g.setColor(0xffffff);
                g.fillRect(0, 0, getWidth( ), getHeight( ));
                g.setColor(0x000000);
                g.drawString("XML Test", 15, 50, Graphics.TOP | Graphics.LEFT);

                cur.inc( );
                model = list.get(cur.getIndex( ));

                g.drawString(model.toString( ), 15, 80, Graphics.TOP
                    | Graphics.LEFT);

                renderMemory(g);
                renderProgress(g);
                flushGraphics( );
            }
        }
    }

    private void renderMemory(
        Graphics g)
    {
        long totalMem = Runtime.getRuntime( ).totalMemory( );
        long freeMem = Runtime.getRuntime( ).freeMemory( );

        g.drawString(
            "arrived models : " + cur.getIndex( ) + "/" + list.size( ), 15,
            120, Graphics.TOP | Graphics.LEFT);
        g.drawString("use memory : " + ( totalMem - freeMem ) + " (byte)", 15,
            150, Graphics.TOP | Graphics.LEFT);
    }

    private void renderProgress(
        Graphics g)
    {
        long prog = ( new Date( ) ).getTime( ) - startedTime;

        if (cur.getIndex( ) != list.size( ) - 1) {
            g.drawString("in progress... : " + prog + " (ms)", 15, 180,
                Graphics.TOP | Graphics.LEFT);
        } else {
            g.drawString("finish up! : " + prog + " (ms)", 15, 180,
                Graphics.TOP | Graphics.LEFT);
        }
    }

    protected void showNotify(){
		t = new Thread((Runnable) this);
		t.start( );
    }

    protected void hideNotify(){
    	t = null;
    }

    public void run() {
        // blinker = this;
        renderCanvas( );
    }
}
