package cornflower.v10.test.canvas;

import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

import org.lixm.core.common.XMLModelizer;




public abstract class BaseCanvas extends GameCanvas {

    protected MIDlet        owner;
    protected XMLModelizer tok;

    protected boolean       suspended;
    protected long          interval = 50;

    public BaseCanvas(
        MIDlet owner, XMLModelizer tok, boolean suppressKeyEvents)
    {
        super(suppressKeyEvents);
        this.owner = owner;
        this.tok = tok;
    }

    /*
     * ���[�v��ŃL�����o�X��`�悷��Ƃ��`���X���[�v���܂��B
     * �`��� �T�X�y���h���鎞�̓E�F�C�g��|���܂��B
     *
     */
    protected void renderSleepOrWait() {
        try {
            Thread.sleep(interval);

            synchronized (this) {
                while (getSuspended( ))
                    wait( );
            }
        } catch (InterruptedException e) {
            // AlertDissolver.showError(e.getMessage(), owner, this);
            System.out.println(e.getMessage( ));
        }
    }

    /*
     * ���[�v��ŃL�����o�X��`�悷��Ƃ��P�t���[�����ɌĂяo���܂��B 
     *
     */
    public abstract void renderCanvas();

    /*
     * �L�����o�X�`�掞�̃X���[�v���Ԃł��B
     * �P�t���[�����ɂ��̃��\�b�h�Ŏ擾�������ԑ҂��܂��B
     */
    public final long getInterval() {
        return interval;
    }

    /*
     * �X���[�v���Ԃ�ݒ肵�܂��B
     */
    public final void setInterval(
        long interval)
    {
        if (interval > 50) {
            this.interval = interval;
        }
    }

    /*
     * �T�X�y���h�����擾���܂��B
     */
    public final boolean getSuspended() {
        return suspended;
    }

    /*
     * �T�X�y���h�����ݒ肵�܂��B
     * ��Ԃ�L�����邾���ŃT�X�y���h�����͕ʂł��B
     */
    public final void setSuspended(
        boolean suspended)
    {
        this.suspended = suspended;
    }

    /*
     * ���݂̃T�X�y���h��Ԃ𔽓]���܂��B
     * setSuspended�ƈႢ�T�X�y���h��~�ߏ�����ĊJ���܂��B
     * 
     */
    public synchronized void toggleSuspend() {
        // blinker = null;
        boolean st = !getSuspended( );
        setSuspended(st);
        if(!st) notify( );
    }

}
