#pragma once

/**
 * VXeݒ.
 */
class CSystemSettings
{
public:
	CSystemSettings();
	~CSystemSettings();

	static CSystemSettings& Instance();

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * JgO[v擾.
	 */
	size_t CurrentGroup() const;
	/**
	 * JgO[vݒ肷.
	 */
	void SetCurrentGroup(size_t val);

	/**
	 * 擾.
	 */
	const std::wstring& SearchString() const;
	/**
	 * ݒ肷.
	 */
	void SetSearchString(const std::wstring& val);

	/**
	 * 擪̂݃}b`邩ǂ擾.
	 */
	bool MatchFirst() const;
	/**
	 * 擪̂݃}b`邩ǂݒ肷.
	 */
	void SetMatchFirst(bool val);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * TopMost ɂ邩ǂ擾.
	 */
	bool TopMost() const;
	/**
	 * TopMost ɂ邩ǂݒ肷.
	 */
	void SetTopMost(bool val);

	/**
	 * ͎ɓ{͂I On ɂ邩ǂ擾.
	 */
	bool ControlIme() const;
	/**
	 * ͎ɓ{͂I On ɂ邩ǂݒ肷.
	 */
	void SetControlIme(bool val);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * ANeBułȂƂɏk\(^Cgo[̂ݕ\)ɂ邩ǂ擾.
	 */
	bool ShrinkOnInactive() const;
	/**
	 * ANeBułȂƂɏk\(^Cgo[̂ݕ\)ɂ邩ǂݒ肷.
	 */
	void SetShrinkOnInactive(bool val);

	/**
	 * ANeBułȂƂɔ\ɂ邩ǂ擾.
	 */
	bool TransparentOnInactive() const;
	/**
	 * ANeBułȂƂɔ\ɂ邩ǂݒ肷.
	 */
	void SetTransparentOnInactive(bool val);

	/**
	 * hbOɔ\(+bZ[W)ɂ邩ǂ擾.
	 */
	bool TransparentOnDrag() const;
	/**
	 * hbOɔ\(+bZ[W)ɂ邩ǂݒ肷.
	 */
	void SetTransparentOnDrag(bool val);

	/**
	 * \̃l (0: - 255:s) 擾.
	 */
	BYTE TransparentAlpha() const;
	/**
	 * \̃l (0: - 255:s) ݒ肷.
	 */
	void SetTransparentAlpha(BYTE val);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * Nbv{[hĎ[h.
	 */
	enum EWatchClipboardMode {
		/// ĎȂ
		WCM_None,
		/// ݂̃O[vɒǉ
		WCM_CurrentGroup,
		/// Nbv{[hO[vɒǉ
		WCM_ClipboardGroup,
	};

	/**
	 * Nbv{[hĎ邩ǂ擾.
	 */
	EWatchClipboardMode WatchClipboardMode() const;
	/**
	 * Nbv{[hĎ邩ǂݒ肷.
	 */
	void SetWatchClipboardMode(EWatchClipboardMode val);

	/**
	 * Nbv{[hĎ̍őTCY擾.
	 */
	size_t ClipboardRecordSize() const;
	/**
	 * Nbv{[hĎ̍őTCYݒ肷.
	 */
	void SetClipboardRecordSize(size_t val);

	////////////////////////////////////////////////////////////////////////////////

	/**
	 * \tɋ󔒍sXLbv邩ǂ擾.
	 */
	bool SkipEmptyLines() const;
	/**
	 * \tɋ󔒍sXLbv邩ǂݒ肷.
	 */
	void SetSkipEmptyLines(bool val);

	/**
	 * \tɋ󔒕g邩ǂ擾.
	 */
	bool TrimSpaces() const;
	/**
	 * \tɋ󔒕g邩ǂݒ肷.
	 */
	void SetTrimSpaces(bool val);

	////////////////////////////////////////////////////////////////////////////////

	// HACK: ݒ_CAOŐݒłȂ̂ŁAgetter ̂

	/**
	 * 񓯊s臒l擾.
	 */
	size_t AsyncSearchThreshold() const;
	/**
	 * 񓯊̃ubNTCY擾.
	 */
	size_t AsyncSearchBlockSize() const;

	/**
	 * t@CƂĂRs[臒l擾.
	 */
	size_t CopyFileThreshold() const;

	/**
	 * VACY[h.
	 * ǂݍݎ̗D` (t@CȂ΂T)
	 * ݎ̌`
	 */
	enum ESerializeMode {
		/// XML
		ESM_Xml,
		/// oCi
		ESM_Binary,
	};
	/**
	 * VACY[h擾.
	 */
	ESerializeMode SerializeMode() const;

	////////////////////////////////////////////////////////////////////////////////
private:
	/// JgO[v
	/// (DataManager ł̓JgύXƂɕύXtO𗧂ĂȂ߁AŊǗ)
	/// (i DataManager ̒lgp. ̕ϐgp̂́ASave/Load ̂)
	/// @see CListPasteDlg::Save(), CListPasteDlg::Load(), CListPasteDoc::SetCurrentGroup()
	size_t m_nCurrentGroup;

	/// 
	std::wstring m_strSearchString;
	/// 擪̂݃}b`邩ǂ
	bool m_bMatchFirst;

	/// TopMost ɂ邩ǂ
	bool m_bTopMost;
	/// ͎ɓ{͂I On ɂ邩ǂ
	bool m_bControlIme;

	/// ANeBułȂƂɏk\(^Cgo[̂ݕ\)ɂ邩ǂ
	bool m_bShrinkOnInactive;
	/// ANeBułȂƂɔ\ɂ邩ǂ
	bool m_bTransparentOnInactive;
	/// hbOɔ\(+bZ[W)ɂ邩ǂ
	bool m_bTransparentOnDrag;
	/// \̃l (0: - 255:s)
	BYTE m_nTransparentAlpha;

	/// Nbv{[hĎ邩ǂ
	EWatchClipboardMode m_nWatchClipboardMode;
	/// Nbv{[hĎ̍őTCY (0 ͖)
	size_t m_nClipboardRecordSize;

	/// \tɋ󔒍sXLbv邩ǂ
	bool m_bSkipEmptyLines;
	/// \tɋ󔒕g邩ǂ
	bool m_bTrimSpaces;

	/// 񓯊s臒l (ACe葽Δ񓯊Ō)
	size_t m_nAsyncSearchThreshold;
	/// 񓯊̃ubNTCY (ʂ̍XVALZtÕ`FbNȂǂsԊu)
	size_t m_nAsyncSearchBlockSize;

	/// t@CƂĂRs[臒l (ACe葽΃eLXĝ݃Rs[)
	size_t m_nCopyFileThreshold;

	/// VACY[h
	ESerializeMode m_serializeMode;

	////////////////////////////////////////////////////////////////////////////////
private:
	friend class boost::serialization::access;
	template<class Archive>
	void serialize(Archive& ar, const unsigned int version)
	{
		using boost::serialization::make_nvp;

		if (version >= 2) {
			ar & make_nvp("CurrentGroup", m_nCurrentGroup);
		}
		ar & make_nvp("SearchString", m_strSearchString);
		ar & make_nvp("MatchFirst", m_bMatchFirst);

		ar & make_nvp("TopMost", m_bTopMost);
		ar & make_nvp("ControlIME", m_bControlIme);

		if (version >= 2) {
			ar & make_nvp("ShrinkOnInactive", m_bShrinkOnInactive);
		}
		if (version >= 1) {
			ar & make_nvp("TransparentOnInactive", m_bTransparentOnInactive);
			ar & make_nvp("TransparentOnDrag", m_bTransparentOnDrag);
			ar & make_nvp("TransparentAlpha", m_nTransparentAlpha);
		}

		// HACK: Oo[Wł bool (0: ĎȂ, 1: Ď) ̂ŁÂ܂ EWatchClipboardMode ƂĎgpł
		ar & make_nvp("WatchClipboard", m_nWatchClipboardMode);
		ar & make_nvp("ClipboardRecordSize", m_nClipboardRecordSize);

		ar & make_nvp("SkipEmptyLines", m_bSkipEmptyLines);
		ar & make_nvp("TrimSpaces", m_bTrimSpaces);

		if (version >= 2) {
			if (version >= 3) {
				ar & make_nvp("AsyncSearchThreshold", m_nAsyncSearchThreshold);
				ar & make_nvp("AsyncSearchBlockSize", m_nAsyncSearchBlockSize);
			}
			else {
				// HACK: v2 ŊԈ m_n tĂ
				ar & make_nvp("m_nAsyncSearchThreshold", m_nAsyncSearchThreshold);
				ar & make_nvp("m_nAsyncSearchBlockSize", m_nAsyncSearchBlockSize);
			}
			ar & make_nvp("CopyFileThreshold", m_nCopyFileThreshold);
		}

		if (version >= 3) {
			ar & make_nvp("SerializeMode", m_serializeMode);
		}
	}
};

BOOST_CLASS_VERSION(CSystemSettings, 3);
