#include "StdAfx.h"
#include "resource.h"
#include "ListPasteDoc.h"
#include "SystemSettings.h"

#include "../GenericLib/Clipboard.h"
#include "../GenericLib/MathUtility.h"
#include "../GenericLib/MiscUtil.h"

////////////////////////////////////////////////////////////////////////////////

CListPasteDoc::CListPasteDoc()
	: m_list(NULL)
	, m_pWnd(NULL)
	, m_bShowAll(true)
{
	m_dataManager = ListPasteLib::CDataManager::CreateInstance();
	ASSERT(m_dataManager);
}

CListPasteDoc::~CListPasteDoc()
{
	// HACK: 񓯊ȂLZ
	VERIFY(CancelAsyncSearch());
}

void CListPasteDoc::Initialize(IList* list, CWnd* pWnd)
{
	ASSERT(!m_list);
	ASSERT(list);
	ASSERT(!m_pWnd);
	ASSERT(pWnd);

	m_list = list;
	m_pWnd = pWnd;
}

////////////////////////////////////////////////////////////////////////////////

size_t CListPasteDoc::GetGroupCount() const
{
	if (!m_dataManager) {
		return 0;
	}

	return m_dataManager->GetGroupCount();
}

bool CListPasteDoc::SetCurrentGroup(size_t index)
{
	if (!m_dataManager) {
		return false;
	}

	// HACK: 񓯊ȂLZ
	VERIFY(CancelAsyncSearch());

	// HACK: ύXtO͐ݒ肵Ȃ
	// HACK: See CListPasteDlg::Save(), Load()
	return m_dataManager->SetCurrentGroup(index, false);
}

size_t CListPasteDoc::GetCurrentGroupIndex() const
{
	if (!m_dataManager) {
		return 0;
	}

	return m_dataManager->GetCurrentGroupIndex();
}

CString CListPasteDoc::GetGroupName(size_t index)
{
	if (!m_dataManager) {
		return CString();
	}
	if (index >= GetGroupCount()) {
		return CString();
	}

	return (LPCTSTR)CW2T(m_dataManager->GetGroup(index).GetName().c_str());
}

bool CListPasteDoc::SetGroupName(size_t index, const CString& strName)
{
	if (!m_dataManager) {
		return false;
	}
	if (index >= GetGroupCount()) {
		return false;
	}

	m_dataManager->GetGroup(index).SetName((LPCWSTR)CT2W(strName));

	return true;
}

bool CListPasteDoc::AddGroup(size_t index, const CString& strName)
{
	if (!m_dataManager) {
		return false;
	}

	// HACK: 񓯊ȂLZ
	VERIFY(CancelAsyncSearch());

	// HACK: ܂ɒǉ
	if (!m_dataManager->Add((LPCWSTR)CT2W(strName))) {
		return false;
	}

	// ǉꂽO[ṽCfbNX
	size_t added = m_dataManager->GetGroupCount() - 1;
	// 낪w肳ĂAŏI
	if (index >= added) {
		return true;
	}

	// HACK: KvɉĈړ
	// ړ
	INT_PTR move = -static_cast<INT_PTR>(added - index);
	// ړ
	if (!m_dataManager->Move(added, move)) {
		// HACK: sAǉ̂폜ďI
		VERIFY(m_dataManager->Delete(added));
		return false;
	}

	return true;
}

bool CListPasteDoc::MoveGroups(const IndexVec& indices, INT_PTR move)
{
	if (!m_dataManager) {
		return false;
	}
	if (indices.empty()) {
		return false;
	}
	if (move == 0) {
		return true;
	}

	// HACK: 񓯊ȂLZ
	VERIFY(CancelAsyncSearch());

	// ΏۃCfbNXɕׂ
	IndexVec idxs = indices;
	std::sort(idxs.begin(), idxs.end());

	// SO[v
	size_t count = m_dataManager->GetGroupCount();
	// (w肳ꂽCfbNXs)
	if (idxs.back() >= count) {
		return false;
	}

	// ֈړ
	if (move > 0) {
		// HACK: Ō̗vfzȂ悤ɂ
		move = Math::Min(static_cast<INT_PTR>(count - 1 - idxs.back()), move);
		if (move == 0) {
			return false;
		}

		// HACK: ̃CfbNXȂ悤ɁAォ珇Ɉړ
		for (IndexVec::reverse_iterator it = idxs.rbegin(); it != idxs.rend(); ++it) {
			VERIFY(m_dataManager->Move(*it, move));
		}
	}
	// Oֈړ
	else {
		// HACK: ŏ̗vf擪zȂ悤ɂ
		move = Math::Max(-static_cast<INT_PTR>(idxs.front()), move);
		if (move == 0) {
			return false;
		}

		// HACK: ̃CfbNXȂ悤ɁAO珇Ɉړ
		for (IndexVec::iterator it = idxs.begin(); it != idxs.end(); ++it) {
			VERIFY(m_dataManager->Move(*it, move));
		}
	}

	return true;
}

bool CListPasteDoc::DeleteGroup(size_t index)
{
	if (!m_dataManager) {
		return false;
	}
	if (index >= GetGroupCount()) {
		return false;
	}

	// HACK: 񓯊ȂLZ
	VERIFY(CancelAsyncSearch());

	return m_dataManager->Delete(index);
}

const ListPasteLib::CDataGroup& CListPasteDoc::GetCurrentGroup() const
{
	ASSERT(m_dataManager);
	return m_dataManager->GetCurrentGroup();
}

ListPasteLib::CDataGroup& CListPasteDoc::GetCurrentGroup()
{
	ASSERT(m_dataManager);
	return m_dataManager->GetCurrentGroup();
}

ListPasteLib::CDataGroup& CListPasteDoc::FindOrCreateGroupByName(const CString& strName)
{
	ASSERT(m_dataManager);

	// O[v
	std::wstring groupName = (LPCWSTR)CT2W(strName);

	// O[vT
	size_t index = m_dataManager->Find(groupName);
	// Ȃ
	if (index == ~0) {
		// O[v𖖔ɒǉ
		m_dataManager->Add(groupName);
		// ̃CfbNX
		index = m_dataManager->GetGroupCount() - 1;
	}

	// O[v擾
	return m_dataManager->GetGroup(index);
}

////////////////////////////////////////////////////////////////////////////////

void CListPasteDoc::Search()
{
	// HACK: 񓯊ȂLZ
	VERIFY(CancelAsyncSearch());

	// HACK: ̎_ŃXbh͓ĂȂ̂ŁACritical Section ɓKv͂Ȃ

	// 
	const std::wstring& search = CSystemSettings::Instance().SearchString();
	// 񂪋
	if (search.empty()) {
		// ׂĕ\
		m_bShowAll = true;
		m_dataIndices.clear();
	}
	else {
		// eLXg̐擪Ƀ}b`邩ǂ
		bool matchFirst = CSystemSettings::Instance().MatchFirst();

		m_bShowAll = false;
		// Ō
		GetCurrentGroup().Search(search, matchFirst, m_dataIndices);
	}
}

size_t CListPasteDoc::GetSearchedCount() const
{
	GenericUtility::CAutoCriticalSection acs(m_csAsyncSearch);
	return m_bShowAll ? GetCurrentTextCount() : m_dataIndices.size();
}

bool CListPasteDoc::SearchAsync(const SearchAsyncNotifyFunc& func)
{
	// HACK: 臒lȉȂA
	if (GetCurrentTextCount() <= CSystemSettings::Instance().AsyncSearchThreshold()) {
		Search();
		return true;
	}

	// HACK: 񓯊ȂLZ
	VERIFY(CancelAsyncSearch());

	// HACK: ̎_ŃXbh͓ĂȂ̂ŁACritical Section ɓKv͂Ȃ

	// 
	const std::wstring& search = CSystemSettings::Instance().SearchString();
	// 񂪋
	if (search.empty()) {
		// ׂĕ\
		m_bShowAll = true;
		m_dataIndices.clear();
		return true;
	}
	else {
		m_bShowAll = false;
		m_dataIndices.clear();
		// HACK: 񓯊Jn
		VERIFY(BeginAsyncSearch(func));
		// (񓯊s)
		return false;
	}
}

bool CListPasteDoc::IsSearching() const
{
	return m_asyncSearchJob && m_asyncSearchJob->IsSearching();
}

const std::wstring& CListPasteDoc::GetText(int item) const
{
	// ׂẴeLXg
	const ListPasteLib::CDataGroup::WStrings& texts = GetCurrentTexts();

	// texts ł̃CfbNX
	size_t index = Item2DataIndex(item);
	if (index >= texts.size()) {
		static const std::wstring err;
		return err;
	}

	return texts[index];
}

bool CListPasteDoc::Modify(int item, const std::wstring& text)
{
	// texts ł̃CfbNX
	size_t index = Item2DataIndex(item);
	if (index >= GetCurrentTextCount()) {
		return false;
	}

	// obNAbv
	BackUp();

	// ύX
	return GetCurrentGroup().Modify(index, text);
}

UINT CListPasteDoc::GetSelectedCount() const
{
	ASSERT(m_list);
	return m_list->GetSelectedCount();
}

void CListPasteDoc::Copy()
{
	// HACK: \tsꍇAeLXg CF_HDROP Ă邱Ƃ͂ȂƎv
	// HACK: (eLXg͗̓eLXgAGNXv[ CF_HDROP)
	// HACK: āANbv{[hɃRs[ꍇAeLXg CF_HDROP 𗼕Rs[Ă悢
	// HACK: ̂߁AGetSelectedTexts() ł͂Ȃ GetSelectedTextVec() gpA
	// HACK: CClipboard::SetText() ł͂Ȃ CClipboard::SetTextData() gpĂ

	// IĂ̂ --> eLXgRs[
	if (GetSelectedCount() > CSystemSettings::Instance().CopyFileThreshold()) {
		// IĂeLXgsŋ؂̂擾
		CString strText = GetSelectedTexts();
		if (strText.IsEmpty()) {
			return;
		}

		// Nbv{[h
		GenericUtility::CClipboard cb;
		// I[vċɂ
		if (!cb.Open(true, m_pWnd)) {
			return;
		}
		// eLXgf[^ݒ肷
		VERIFY(cb.SetTextData(strText));

	}
	// IĂ̂Ȃ --> t@CƂĂRs[
	else {
		// IĂeLXg
		std::vector<CString> texts = GetSelectedTextVec();
		if (texts.empty()) {
			return;
		}
		// s؂ŘA
		CString strText = GenericUtility::ConcatenateStrings(texts, _T("\r\n"));
		if (strText.IsEmpty()) {
			return;
		}

		// Nbv{[h
		GenericUtility::CClipboard cb;
		// I[vċɂ
		if (!cb.Open(true, m_pWnd)) {
			return;
		}
		// eLXgf[^ݒ肷
		VERIFY(cb.SetTextData(strText));

		// ׂĂLȃt@CpXł
		if (GenericUtility::AreValidFilePaths(texts)) {
			// t@CƂăNbv{[hɃRs[
			VERIFY(cb.SetFileNameData(texts));
		}
	}
}

bool CListPasteDoc::Paste()
{
	// Nbv{[h當擾
	std::vector<std::wstring> texts = GetTextsFromClipboard();
	if (texts.empty()) {
		return false;
	}

	// ǉʒu
	size_t insertPos = GetSelectedDataIndex();
	if (insertPos == ~0) {
		// 
		insertPos = GetCurrentTextCount();
	}

	// obNAbv
	BackUp();

	// xɒǉ
	return GetCurrentGroup().Add(insertPos, texts);
}

void CListPasteDoc::Delete()
{
	// HACK: Ŏ擾ł͂
	ListPasteLib::CDataGroup::IndexVec indices = GetAllSelectedDataIndices();

	// obNAbv
	BackUp();

	// HACK: 폜Ώۂ̃CfbNXȂ悤ɁAtɍ폜
	// HACK: (́AAĂȂ\邱Ƃɒ)
	for (ListPasteLib::CDataGroup::IndexVec::reverse_iterator it = indices.rbegin(); it != indices.rend(); ++it) {
		// HACK: DEL L[ςȂŘAč폜ƂAs\
		GetCurrentGroup().Delete(*it);
	}
}

bool CListPasteDoc::PasteOnDrawClipboard(bool& currentGroupUpdated)
{
	currentGroupUpdated = false;

	if (!m_dataManager) {
		return false;
	}
	// HACK: Rs[̂̓y[XgȂ
	if (m_pWnd && m_pWnd->GetSafeHwnd() == ::GetClipboardOwner()) {
		return false;
	}

	size_t nClipboardRecordSize = CSystemSettings::Instance().ClipboardRecordSize();

	// HACK: ɃI[vƎsꍇ̂ŁAgC
	// gC
	static const size_t RETRY = 10;
	// Nbv{[h當擾
	std::vector<std::wstring> texts = GetTextsFromClipboard(nClipboardRecordSize, RETRY);
	if (texts.empty()) {
		return false;
	}

	// ΏۃO[v
	ListPasteLib::CDataGroup* pgroup = NULL;
	// JgO[vɒǉ
	if (CSystemSettings::Instance().WatchClipboardMode() == CSystemSettings::WCM_CurrentGroup) {
		// JgO[v
		pgroup = &GetCurrentGroup();
	}
	// Nbv{[hO[vɒǉ
	else {
		ASSERT(CSystemSettings::Instance().WatchClipboardMode() == CSystemSettings::WCM_ClipboardGroup);
		// Nbv{[hO[v
		pgroup = &FindOrCreateGroupByName(GenericUtility::LoadStringRes(IDS_GROUP_NAME_CLIPBOARD));
	}
	ListPasteLib::CDataGroup& group = *pgroup;

	// ΏۂJgO[vł
	if (pgroup == &GetCurrentGroup()) {
		currentGroupUpdated = true;
	}

	// TCY
	if (nClipboardRecordSize > 0) {
#if 1
		// HACK: KvȂ͂Aꉞ`FbNĂ
		if (texts.size() > nClipboardRecordSize) {
			texts.resize(nClipboardRecordSize);
		}
#endif

		// HACK: łptH[}X悭Ȃ悤ɁAɍ폜
		// c (ő吔)
		size_t maxSize = nClipboardRecordSize - texts.size();
		// ݂̐
		size_t currentSize = group.GetTexts().size();
		// ő吔𒴂Ȃ悤ɁA폜
		while (currentSize > maxSize) {
			VERIFY(group.Delete(--currentSize));
		}
	}

	// HACK: obNAbv͎Ȃ

	// O[v̐擪ɒǉ
	return group.Add(0, texts);
}

void CListPasteDoc::BackUp(EBackUpID id)
{
	ASSERT(0 <= id && id < BU_Size);

	if (!m_dataManagerBak[id]) {
		m_dataManagerBak[id] = ListPasteLib::CDataManager::CreateInstance();
		ASSERT(m_dataManagerBak[id]);
	}

	// HACK: obNAbv (ۂƃRs[)
	// TODO: dvC (f[^傫ƂAx胁gpʂ̕肩)
	ASSERT(m_dataManager);
	m_dataManagerBak[id]->Copy(m_dataManager);
}

void CListPasteDoc::ClearBackUp(EBackUpID id)
{
	ASSERT(0 <= id && id < BU_Size);
	m_dataManagerBak[id].reset();
}

void CListPasteDoc::SwapBackUp(EBackUpID id1, EBackUpID id2)
{
	ASSERT(0 <= id1 && id1 < BU_Size);
	ASSERT(0 <= id2 && id2 < BU_Size);

	if (id1 != id2) {
		std::swap(m_dataManagerBak[id1], m_dataManagerBak[id2]);
	}
}

bool CListPasteDoc::Undo(EBackUpID id)
{
	ASSERT(0 <= id && id < BU_Size);

	// obNAbvȂ
	if (!m_dataManagerBak[id]) {
		return false;
	}

	// obNAbvƓւ
	std::swap(m_dataManager, m_dataManagerBak[id]);

	return true;
}

bool CListPasteDoc::CanUndo(EBackUpID id) const
{
	ASSERT(0 <= id && id < BU_Size);
	// obNAbv邩ǂ
	return m_dataManagerBak[id];
}

std::vector<CString> CListPasteDoc::GetSelectedTextVec() const
{
	ASSERT(m_list);
	std::vector<CString> texts;

	// ׂẴeLXg
	const ListPasteLib::CDataGroup::WStrings& txts = GetCurrentTexts();

	POSITION pos = m_list->GetFirstSelectedItemPosition();
	while (pos) {
		// f[^CfbNX
		size_t index = Item2DataIndex(m_list->GetNextSelectedItem(pos));
		if (index >= (int)txts.size()) {
			continue;
		}
		// ΉeLXgǉ
		texts.push_back((LPCTSTR)CW2T(txts[index].c_str()));
	}

	return texts;
}

CString CListPasteDoc::GetSelectedTexts() const
{
	ASSERT(m_list);
#if 0
	CString texts;

	// ׂẴeLXg
	const ListPasteLib::CDataGroup::WStrings& txts = GetCurrentTexts();

	bool firstTime = true;
	POSITION pos = m_list->GetFirstSelectedItemPosition();
	while (pos) {
		// HACK: ڈȍ~͉s (CR+LF) ŋ؂
		// HACK: 󔒂Lӂȃf[^Ƃ݂ȂA󔒂ǂł͂ȂŏǂŔf
		if (firstTime) {
			firstTime = false;
		}
		else {
			texts.Append(_T("\r\n"));
		}

		// f[^CfbNX
		size_t index = Item2DataIndex(m_list->GetNextSelectedItem(pos));
		if (index >= (int)txts.size()) {
			continue;
		}
		// ΉeLXgǉ
		texts.Append(CW2T(txts[index].c_str()));
	}

	return texts;
#else
	// HACK: CString::Append() ͒x̂ŁAx vector ɓĂŌ CString ɕϊ

	std::vector<wchar_t> texts;

	// ׂẴeLXg
	const ListPasteLib::CDataGroup::WStrings& txts = GetCurrentTexts();

	bool firstTime = true;
	POSITION pos = m_list->GetFirstSelectedItemPosition();
	while (pos) {
		// HACK: ڈȍ~͉s (CR+LF) ŋ؂
		// HACK: 󔒂Lӂȃf[^Ƃ݂ȂA󔒂ǂł͂ȂŏǂŔf
		if (firstTime) {
			firstTime = false;
		}
		else {
			static const std::wstring NEWLINE = L"\r\n";
			texts.insert(texts.end(), NEWLINE.begin(), NEWLINE.end());
		}

		// f[^CfbNX
		size_t index = Item2DataIndex(m_list->GetNextSelectedItem(pos));
		if (index >= (int)txts.size()) {
			continue;
		}
		// ΉeLXgǉ
		const std::wstring& text = txts[index];
		texts.insert(texts.end(), text.begin(), text.end());
	}

#ifdef _UNICODE
	// CString ɕϊ
	return CString(&texts[0], static_cast<int>(texts.size()));
#else	// #ifdef _UNICODE
	//  \0 ǉ
	texts.push_back(L'\0');
	// CString ɕϊ
	return CString(CW2T(&texts[0]));
#endif	// #ifdef _UNICODE
#endif
}

const ListPasteLib::CDataGroup::WStrings& CListPasteDoc::GetCurrentTexts() const
{
	return GetCurrentGroup().GetTexts();
}

size_t CListPasteDoc::GetCurrentTextCount() const
{
	return GetCurrentGroup().GetTexts().size();
}

////////////////////////////////////////////////////////////////////////////////

bool CListPasteDoc::BeginAsyncSearch(const SearchAsyncNotifyFunc& func)
{
	// HACK: 񓯊Xbh͓ĂȂ͂ (邢͑ǑsAIɓĂ͂)

	using namespace GenericUtility;

	// HACK: NeBJZNVsv

	// 񓯊Wu܂Ȃ΍쐬
	// HACK: WuIuWFNg͂̓sx쐬ȂĂ悢
	if (!m_asyncSearchJob) {
		// HACK: WuO[v ID ͓Kł悢
		m_asyncSearchJob.reset(new CAsyncSearchJob(0 /* WuO[v ID */, m_dataIndices, m_csAsyncSearch));
		if (!m_asyncSearchJob) {
			return false;
		}
	}

	// 񓯊p[J[Xbhv[܂Ȃ΍쐬
	if (!m_threadPool) {
		// [J[Xbhv[쐬
		m_threadPool.reset(new CWorkerThreadPool);
		if (!m_threadPool) {
			return false;
		}

		// [J[Xbhv[
		// HACK: (񓯊Wu𓯎ɈȂ̂ŁAXbh͈ł悢)
		if (!m_threadPool->Initialize(1)) {
			return false;
		}
	}
	VERIFY(m_threadPool->Reset(m_asyncSearchJob->GetGroupID()));

	// 
	const std::wstring& search = CSystemSettings::Instance().SearchString();
	// eLXg̐擪Ƀ}b`邩ǂ
	bool matchFirst = CSystemSettings::Instance().MatchFirst();
	// 񓯊WuZbgAbv
	m_asyncSearchJob->BeginAsyncSearch(&GetCurrentGroup(), search, matchFirst, func);

	// Wuǉ (Ɏs͂)
	return m_threadPool->AddJob(m_asyncSearchJob);
}

bool CListPasteDoc::CancelAsyncSearch()
{
	// HACK: 񓯊Wuƃ[J[Xbh̃CX^X̓CXbh炵gȂ̂ŁA
	// HACK: CX^X`FbN̓NeBJZNV̒ɓȂĂ悢
	if (!m_threadPool) {
		return true;
	}
	if (!m_asyncSearchJob) {
		return true;
	}

	// HACK: LZAg~bNɍs߂ɁAŖIɃNeBJZNVɓ
	GenericUtility::CAutoCriticalSection acs(m_csAsyncSearch);

	// 񓯊
	if (m_asyncSearchJob->IsSearching()) {
		// LZtO𗧂Ă
		m_asyncSearchJob->BeginCancel();

		{
			GenericUtility::CAutoLeaveCriticalSection alcs(m_csAsyncSearch);

			// ҂
			VERIFY(m_threadPool->WaitAll(m_asyncSearchJob->GetGroupID()));
		}

		// 񓯊tONAāALZR[obNĂ
		m_asyncSearchJob->EndCancel();
	}

	return true;
}

int CListPasteDoc::GetSelectedItem() const
{
	ASSERT(m_list);

	POSITION pos = m_list->GetFirstSelectedItemPosition();
	if (!pos) {
		return -1;
	}

	// IĂŏ̍
	return m_list->GetNextSelectedItem(pos);
}

size_t CListPasteDoc::Item2DataIndex(int item) const
{
	if (item < 0) {
		return ~0;
	}

	// f[^CfbNX
	size_t index = 0;
	// ׂĕ\Ă
	if (m_bShowAll) {
		// Xg̃CfbNX == texts ł̃CfbNX
		index = item;
	}
	else {
		GenericUtility::CAutoCriticalSection acs(m_csAsyncSearch);

		// Xg̃CfbNX == m_dataIndices ł̃CfbNX
		if (item >= (int)m_dataIndices.size()) {
			return ~0;
		}
		index = m_dataIndices[item];
	}

	if (index >= GetCurrentTextCount()) {
		return ~0;
	}
	return index;
}

size_t CListPasteDoc::GetSelectedDataIndex() const
{
	return Item2DataIndex(GetSelectedItem());
}

ListPasteLib::CDataGroup::IndexVec CListPasteDoc::GetAllSelectedDataIndices() const
{
	ASSERT(m_list);
	ListPasteLib::CDataGroup::IndexVec indices;

	POSITION pos = m_list->GetFirstSelectedItemPosition();
	while (pos) {
		// f[^CfbNXɕϊ
		size_t index = Item2DataIndex(m_list->GetNextSelectedItem(pos));
		// LȂǉ
		if (index != ~0) {
			indices.push_back(index);
		}
	}

	return indices;
}

std::vector<std::wstring> CListPasteDoc::GetTextsFromClipboard(size_t maxTexts, size_t retry)
{
	// Nbv{[h當擾
	CString strText = GenericUtility::CClipboard::GetText(m_pWnd, retry);
	if (strText.IsEmpty()) {
		return std::vector<std::wstring>();
	}

	// HACK: s "\r\n" (CR+LF) łƉ肵Ă

	bool bSkipEmptyLines = CSystemSettings::Instance().SkipEmptyLines();
	bool bTrimSpaces     = CSystemSettings::Instance().TrimSpaces();

	// ׂẴeLXg
	std::vector<std::wstring> texts;
	int curPos = 0;
	// HACK: LF ŕ
	CString token= strText.Tokenize(_T("\n"), curPos);
	// HACK: CR ̂ŁAAso
	while (!token.IsEmpty()) {
		// HACK:  CR ͍폜
		token.TrimRight(_T("\r"));

		// 󔒕g
		if (bTrimSpaces) {
			token.Trim();
		}

		// 󔒍sXLbv
		if (!bSkipEmptyLines || !token.IsEmpty()) {
			texts.push_back((LPCWSTR)CT2W(token));
			// ő吔ɒBI
			if (maxTexts > 0 && texts.size() >= maxTexts) {
				break;
			}
		}

		// ̃g[N
		token = strText.Tokenize(_T("\n"), curPos);
	}

	return texts;
}

////////////////////////////////////////////////////////////////////////////////

CListPasteDoc::CAsyncSearchJob::CAsyncSearchJob(
	int nGroupID,
	ListPasteLib::CDataGroup::IndexVec& dataIndices,
	GenericUtility::CCriticalSection& csAsyncSearch)
	: m_nGroupID(nGroupID)
	, m_dataIndices(dataIndices)
	, m_cs(csAsyncSearch)
	, m_matchFirst(true)
	, m_bIsSearching(false)
	, m_bCancel(false)
{
}

CListPasteDoc::CAsyncSearchJob::~CAsyncSearchJob()
{
}

void CListPasteDoc::CAsyncSearchJob::BeginAsyncSearch(
	ListPasteLib::CDataGroup* pDataGroup,
	const std::wstring& search, bool matchFirst,
	const SearchAsyncNotifyFunc& searchAsyncNotifyFunc)

{
#if 0	// HACK: 񓯊XbhƓɓƂ͂Ȃ̂ŁANeBJZNVsv
	GenericUtility::CAutoCriticalSection acs(m_cs);
#endif

	// Ώۃf[^O[v
	m_pDataGroup   = pDataGroup;
	// 
	m_search       = search;
	m_matchFirst   = matchFirst;

	// 񓯊
	m_bIsSearching = true;
	// LZtO
	m_bCancel      = false;
	// 񓯊̊m点R[obN
	m_notifyFunc   = searchAsyncNotifyFunc;
}

bool CListPasteDoc::CAsyncSearchJob::IsSearching() const
{
	GenericUtility::CAutoCriticalSection acs(m_cs);
	return m_bIsSearching;
}

void CListPasteDoc::CAsyncSearchJob::BeginCancel()
{
	GenericUtility::CAutoCriticalSection acs(m_cs);
	m_bCancel = true;
}

void CListPasteDoc::CAsyncSearchJob::EndCancel()
{
	GenericUtility::CAutoCriticalSection acs(m_cs);

	// 
	m_bIsSearching = false;

	// 񓯊̊m点R[obNĂ
	if (m_notifyFunc) {
		m_notifyFunc(true /* LZǂ */);
	}
}

bool CListPasteDoc::CAsyncSearchJob::Execute()
{
	// HACK: łɁAWuXbhĕ񏈗A
	// HACK: ܂ÂƂȂĂɖ͂ȂȂ̂ŁAPɏ

	// HACK: ߂ĺǍLZ҂邩ǂ\
	// HACK: Ō m_bIsSearching = false ƂĂ̂ŁA m_bIsSearching ƓlԂ΂悢
	// HACK: See IJob::Execute()
	// ߂l
#define RETURN_COMPLETE		(m_bIsSearching)
#define RETURN_INCOMPLETE	(m_bIsSearching)

	// HACK: m_pDataGroup ̃ANZX̓NeBJZNVsv
	if (!m_pDataGroup) {
		return RETURN_INCOMPLETE;
	}

	// ׂẴeLXg̐ ()
	size_t total = m_pDataGroup->GetTexts().size();
	// vOX [0, total]
	size_t progress = 0;

	{
		GenericUtility::CAutoCriticalSection acs(m_cs);

		// LZꂽ
		if (m_bCancel) {
			return RETURN_INCOMPLETE;
		}
	}

	// 񂠂茟f[^
	size_t nBlockSize = CSystemSettings::Instance().AsyncSearchBlockSize();

	ListPasteLib::CDataGroup::IndexVec indexVec;
	indexVec.reserve(nBlockSize);
	while (progress < total) {
		// JnCfbNX
		size_t begin = progress;
		// ICfbNX (܂܂Ȃ)
		size_t end   = Math::Min(progress + nBlockSize, total);
		// 
		m_pDataGroup->Search(begin, end, m_search, m_matchFirst, indexVec);
		// ̊JnCfbNX
		progress = end;

		{
			GenericUtility::CAutoCriticalSection acs(m_cs);

			// LZꂽ
			if (m_bCancel) {
				return RETURN_INCOMPLETE;
			}

			// TODO: empty() `FbN͕svH
			if (!indexVec.empty()) {
				m_dataIndices.insert(m_dataIndices.end(), indexVec.begin(), indexVec.end());
			}
		}
	}

	{
		GenericUtility::CAutoCriticalSection acs(m_cs);

		// HACK: łLZ`FbNs
		// HACK: ALZĂ΃LZ̕D悷
		// LZꂽ
		if (m_bCancel) {
			return RETURN_INCOMPLETE;
		}

		// 
		m_bIsSearching = false;

		// 񓯊̊m点R[obNĂ
		if (m_notifyFunc) {
			m_notifyFunc(false /* LZǂ */);
		}
	}

	// TODO: WuSɏI܂ł̃^COŖ͂ȂH
	// TODO: --> XbhȂ̂ŁȀuԂɓWu AddJob() ĂA͑ҋ@L[ɓ
	// TODO:     return false ŎsL[폜ꂽAҋ@L[ɂ̂̂܂܎s͂
	return RETURN_COMPLETE;
}

int CListPasteDoc::CAsyncSearchJob::GetGroupID()
{
	return m_nGroupID;
}

////////////////////////////////////////////////////////////////////////////////

namespace {

	/**
	 * CDataManager ̐ݒۑpt@C擾.
	 */
	const std::wstring& GetDataManagerFilename(bool save)
	{
		// HACK: }`XbhΉ
		// oCi
		static const std::wstring BINARY_FILE = GenericUtility::GetStorageFilename(L"ListPasteData.dat");
		// XML
		static const std::wstring XML_FILE    = GenericUtility::GetStorageFilename(L"ListPasteData.xml");

		// VACY[h
		CSystemSettings::ESerializeMode mode = CSystemSettings::Instance().SerializeMode();

		// ۑ
		if (save) {
			// VACY[hǂɕԂ
			return mode == CSystemSettings::ESM_Binary ? BINARY_FILE : XML_FILE;
		}
		// ǂݍݎ
		else {
			// oCi[h
			if (mode == CSystemSettings::ESM_Binary) {
				// HACK: oCit@C΂̖OԂ
				// HACK: Ȃ XML t@CԂ (XML t@CȂꍇł̂܂ܕԂ OK)
				// HACK: oCiȂ XML t@CŝƂ́A\ʃG[bZ[Wo邪AʓIɂ͖Ȃ
				return GenericUtility::FileExists(BINARY_FILE) ? BINARY_FILE : XML_FILE;
			}
			// XML [h
			else {
				return GenericUtility::FileExists(XML_FILE) ? XML_FILE : BINARY_FILE;
			}
		}
	}

}	// anonymous namespace

bool CListPasteDoc::Save(bool force)
{
	ASSERT(m_dataManager);

	const std::wstring& filename = GetDataManagerFilename(true);

	// HACK: ݂ł͂Ȃꍇ́AύXĂ炸At@C݂΁Â܂܏I
	if (!force && !m_dataManager->IsDirty() && GenericUtility::FileExists(filename)) {
		return true;
	}

	// t@C
	return m_dataManager->Save(filename);
}

bool CListPasteDoc::Load()
{
	// CX^X쐬
	// HACK: t@CȂꍇɃZbg邽߁Aɍč쐬
	m_dataManager = ListPasteLib::CDataManager::CreateInstance();
	ASSERT(m_dataManager);

	const std::wstring& filename = GetDataManagerFilename(false);

	// HACK: t@CȂ () ́AƂ݂Ȃ
	if (!GenericUtility::FileExists(filename)) {
		return true;
	}

	// t@Cǂݍ
	return m_dataManager->Load(filename);
}
