/**
 * @file  Thread.cpp
 * @brief XbhǗNX.
 *
 * @author JIN
 *
 * Copyright (C) 2004- JIN All rights reserved.
 */
#include "stdafx.h"

#include "thread.h"

namespace GenericUtility {

//-----------------------------------------------------------------------------
CThread::CThread() : m_hThread(NULL)
{
}

CThread::~CThread()
{
	if (m_hThread) {
		::CloseHandle(m_hThread);
	}
}

bool CThread::Create(const RunnablePtr& runnable)
{
	if (m_hThread) {
		return false;
	}
	m_runnable.reset();
	if (!runnable || !runnable->Initialize()) {
		return false;
	}
	m_runnable = runnable;
	DWORD dwThreadId;
	m_hThread = ::CreateThread(NULL, 0, CThread::ThreadProc, (LPVOID)&m_runnable, 0, &dwThreadId);
	if (!m_hThread) {
		m_runnable.reset();
		return false;
	}
#if 0
	::SetThreadPriority(m_hThread, THREAD_PRIORITY_BELOW_NORMAL);
#endif
	return true;
}

bool CThread::Peek(DWORD* pdwReturnCode)
{
	if (!m_hThread) {
		return false;
	}
	if (::WaitForSingleObject(m_hThread, 0) != WAIT_OBJECT_0) {
		return false;
	}
	if (pdwReturnCode) {
		*pdwReturnCode = 0;
		VERIFY(::GetExitCodeThread(m_hThread, pdwReturnCode));
	}
	::CloseHandle(m_hThread);
	m_hThread = NULL;
	return true;
}

bool CThread::Stop(DWORD* pdwReturnCode)
{
	if (!m_hThread) {
		return false;
	}
	RunnablePtr runnable = m_runnable.lock();
	if (!runnable) {
		return false;
	}
	if (!runnable->Stop()) {
		return false;
	}
	bool ret = true;
	if (::WaitForSingleObject(m_hThread, INFINITE) != WAIT_OBJECT_0) {
		ret = false;
	}
	if (pdwReturnCode) {
		*pdwReturnCode = 0;
		VERIFY(::GetExitCodeThread(m_hThread, pdwReturnCode));
	}
	if (!::CloseHandle(m_hThread)) {
		ret = false;
	}
	m_hThread = NULL;
	return true;
}

DWORD WINAPI CThread::ThreadProc(LPVOID lpParameter)
{
	RunnableWPtr* wrunnable = static_cast<RunnableWPtr*>(lpParameter);
	if (!wrunnable) {
		return ~0;
	}
	RunnablePtr runnable = wrunnable->lock();
	if (!runnable) {
		return ~0;
	}
	return runnable->Run();
}

}	// namespace GenericUtility
