/**
 * @file  CpuMap.h
 * @brief CPU ԍ CPU  APIC ID ̃}bvNX`.
 *
 * @author JIN
 *
 * Copyright (C) 2008- JIN All rights reserved.
 */
#pragma once

#include <boost/optional.hpp>

namespace GenericUtility {

/**
 * CPU ԍ CPU  APIC ID ̃}bv.
 */
class CCpuMap
{
private:
	CCpuMap();

public:
	~CCpuMap();

	/**
	 * VOgCX^X擾.
	 */
	static CCpuMap& Instance();

	/**
	 * SSE2 gp\ǂ擾.
	 */
	bool IsSSE2Available() const;

	/**
	 * VXẽvZbT擾.
	 */
	DWORD GetNumberOfProcessors() const;
	/**
	 * ݂̃vZXŎgpłvZbT擾.
	 */
	DWORD GetCurrentProcessAffinityBits() const;

	/**
	 * ݂̃vZX Affinity Mask 擾.
	 */
	bool GetCurrentProcessAffinityMask(DWORD_PTR& dwProcessAffinityMask) const;

	/**
	 * ݎs CPU  CPU ԍ擾.
	 * @return -1 G[
	 */
	int GetCurrentProcessorNumber();

protected:
	typedef boost::optional<BYTE> ApicIdType;

	/**
	 * ݃XbhsĂ CPU  APIC ID 擾.
	 */
	static ApicIdType GetApicId();

private:
	/// SSE2 gp\ǂ
	bool m_bSSE2Available;

	/// VXẽvZbT
	DWORD m_dwNumberOfProcessors;

	/// ݂̃vZX̋N Affinity Mask
	DWORD_PTR m_dwProcessAffinityMask;
	/// ݂̃vZX̋N Affinity Mask  1 ̃rbg̐
	DWORD m_dwProcessAffinityBits;

	/// CPU  APIC ID
	ApicIdType m_ApicId[sizeof(DWORD_PTR) * 8 /* bit/byte */];
};

}	// namespace GenericUtility
