#!perl

use Test::More tests => 3;

BEGIN {
  require "t/common.pl";
  start_server();
}

$ldap = client();
if (!$ldap) {
  die "can't contact ldap server";
}

$mesg = $ldap->bind($MANAGERDN, password => $PASSWD);

if ($mesg->code) {
  die "can't bind: ".$mesg->error;
}


# Add
ldif_populate($ldap, "data/11-in.ldif");

ok(!compare("$TEMPDIR/user11.csv","data/1101-cmp.csv"), "data/1101-cmp.csv");


$dn = "uid=user11,ou=Tech,ou=IT,ou=People,$LDAPDN";

# Modify
$mesg = $ldap->modify($dn, replace => {'mail' => 'user01@lism.org'});
ok(!compare("$TEMPDIR/user11.csv","data/1102-cmp.csv"), "data/1102-cmp.csv");


# Delete
$mesg = $ldap->delete($dn);
ok(!-f "$TEMPDIR/user11.csv", "delete uid=user11");
