﻿using System;
using System.Drawing;
using System.Windows.Forms;
using Plugin;

namespace VFlip {
    public class VFlip : IPlugin{

        private string m_language = "en";

        /// <summary>
        /// プラグインの名称
        /// </summary>
        public string Name {
            get {
                return "VFlip";
            }
        }


        public void ApplyLanguage( string language_code ) {
            if ( ISO639.CheckValidity( language_code ) ) {
                m_language = language_code;
            }
        }


        /// <summary>
        /// プラグインのタイプを表す。
        /// </summary>
        public ulong Type {
            get {
                return Plugin.Constants.LS_NO_EVENT_HANDLER;
            }
        }

        /// <summary>
        /// プラグインの簡潔な説明文。
        /// </summary>
        public string Abstract {
            get {
                if ( m_language == "ja" ) {
                    return "画像の上下を反転させるプラグインです";
                } else {
                    return "vertically flip the image";
                }
            }
        }

        /// <summary>
        /// イベントハンドラ。このプラグインの設定メニューが押された時呼び出されます。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public DialogResult BaseSetting() {
            return DialogResult.Cancel;
        }

        public DialogResult EntrySetting(ref string entry_config ) {
            return DialogResult.Cancel;
        }

        /// <summary>
        /// 設定値を格納した文字列を指定します。
        /// </summary>
        /// <returns></returns>
        public string Config {
            get {
                return "";
            }
            set { }
        }

        /// <summary>
        /// フレームに加工を施す関数
        /// </summary>
        /// <param name="bmp"></param>
        /// <param name="time"></param>
        public void Apply( ref Bitmap bmp, float time, float e_begin, float e_end, ref string e_body ) {
            bmp.RotateFlip( RotateFlipType.RotateNoneFlipY );
        }

        public void Render( Graphics g, Size size, float time, string mouth, string reserved ) {
        }
    }
}
