/*
 * VsqCommon.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

import java.awt.*;

/**
 * vsqファイルのメタテキストの[Common]セクションに記録される内容を取り扱う
 * @author kbinani
 */
public class VsqCommon implements Cloneable {
    public String m_version;
    public String m_name;
    public String m_color;
    public int m_dynamics_mode;
    public int m_play_mode;

    public Object clone() {
        String[] spl = m_color.split( ",", 3 );
        int r = Integer.parseInt( spl[0] );
        int g = Integer.parseInt( spl[1] );
        int b = Integer.parseInt( spl[2] );
        Color color = new Color( r, g, b );
        VsqCommon res = new VsqCommon( m_name, color, m_dynamics_mode, m_play_mode );
        res.m_version = m_version;
        return res;
    }

    /**
     * 各パラメータを指定したコンストラクタ
     * @param name トラック名
     * @param color Color値（意味は不明）
     * @param dynamics_mode DynamicsMode（デフォルトは1）
     * @param play_mode PlayMode（デフォルトは1）
     */
    public VsqCommon( String name, Color color, int dynamics_mode, int play_mode ) {
        m_version = "DSB301";
        m_name = name;
        m_color = color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        m_dynamics_mode = dynamics_mode;
        m_play_mode = play_mode;
    }

    /**
     * MetaTextのテキストファイルからのコンストラクタ
     * @param sr 読み込むテキストファイル
     * @param last_line 読み込んだ最後の行が返される
     */
    public VsqCommon( TextMemoryStream sr, TextResult last_line ) {
        m_version = "";
        m_name = "";
        m_color = "0,0,0";
        m_dynamics_mode = 0;
        m_play_mode = 0;
        last_line.set( sr.readLine() );
        String[] spl;
        while ( !last_line.get().startsWith( "[" ) ) {
            spl = last_line.get().split( "=" );
            if ( spl[0].equals( "Version" ) ) {
                this.m_version = spl[1];
            } else if ( spl[0].equals( "Name" ) ) {
                this.m_name = spl[1];
                break;
            } else if ( spl[0].equals( "Color" ) ) {
                this.m_color = spl[1];
            } else if ( spl[0].equals( "DynamicsMode" ) ) {
                this.m_dynamics_mode = Integer.parseInt( spl[1] );
            } else if ( spl[0].equals( "PlayMode" ) ) {
                this.m_play_mode = Integer.parseInt( spl[1] );
            }
            if ( sr.peek() < 0 ) {
                break;
            }
            last_line.set( sr.readLine() );
        }
    }

    /**
     * インスタンスの内容をテキストファイルに出力します
     *
     * @param sw 出力先
     */
    public void write( TextMemoryStream sw ) {
        sw.writeLine( "[Common]" );
        sw.writeLine( "Version=" + m_version );
        sw.writeLine( "Name=" + m_name );
        sw.writeLine( "Color=" + m_color );
        sw.writeLine( "DynamicsMode=" + m_dynamics_mode );
        sw.writeLine( "PlayMode=" + this.m_play_mode );
    }

}
