/*
 * VibratoHandle.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

/**
 *
 * @author kbinani
 */
public class VibratoHandle extends VsqHandle implements Cloneable {
    public Object clone() {
        VibratoHandle result = new VibratoHandle();
        result.Type = Type;
        result.Index = Index;
        result.IconID = IconID;
        result.IDS = this.IDS;
        result.Original = this.Original;
        result.Caption = this.Caption;
        result.Length = this.Length;
        result.StartDepth = this.StartDepth;
        result.DepthBPNum = this.DepthBPNum;
        if ( DepthBPX != null ) {
            result.DepthBPX = (float[])this.DepthBPX.clone();
        }
        if ( DepthBPY != null ) {
            result.DepthBPY = (int[])this.DepthBPY.clone();
        }
        result.StartRate = this.StartRate;
        result.RateBPNum = this.RateBPNum;
        if ( this.RateBPX != null ) {
            result.RateBPX = (float[])this.RateBPX.clone();
        }
        if ( this.RateBPY != null ) {
            result.RateBPY = (int[])this.RateBPY.clone();
        }
        return result;
    }


    /*public int Original {
    get {
    return m_original;
    }
    set {
    m_original = value;
    }
    }*/
    /*public int Length {
    get {
    return m_length;
    }
    set {
    m_length = value;
    }
    }*/
    /*public string Caption {
    get {
    return m_caption;
    }
    set {
    m_caption = value;
    }
    }*/
    /*public property String IDS {
    get {
    return m_ids;
    }
    set {
    m_ids = value;
    }
    };*/
    /*public string IconID {
    get {
    return m_icon_id;
    }
    set {
    m_icon_id = value;
    }
    }*/

    /*public int StartDepth {
    get {
    return m_start_depth;
    }
    set {
    m_start_depth = value;
    }
    }*/
    /*public int StartRate {
    get {
    return m_start_rate;
    }
    set {
    m_start_rate = value;
    }
    }*/
    /*public int DepthBPNum {
    get {
    return m_depth_bp_num;
    }
    set {
    m_depth_bp_num = value;
    }
    }*/
    /*public property int RateBPNum {
    get {
    return m_rate_bp_num;
    }
    set {
    m_rate_bp_num = value;
    }
    };*/
    /*public property float[] DepthBPX {
    get {
    return m_depth_bp_x;
    }
    set {
    m_depth_bp_x = value;
    }
    };*/
    /*public property int[] DepthBPY {
    get {
    return m_depth_bp_y;
    }
    set {
    m_depth_bp_y = value;
    }
    };*/
    /*public property float[] RateBPX {
    get {
    return m_rate_bp_x;
    }
    set {
    m_rate_bp_x = value;
    }
    };*/

    /*public property int[] RateBPY {
    get {
    return m_rate_bp_y;
    }
    set {
    m_rate_bp_y = value;
    }
    };*/
}
