/************************************************************
* Copyright (C) 2006-2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#ifndef WIIREMOTE_IMPL_H
#define WIIREMOTE_IMPL_H

#include "wiiremote.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
* Wii Remote device infomation
**/
#define WRMT_DEVICE_CLASS 0x00002504
#define WRMT_DEVICE_NAME "Nintendo RVL-CNT-01"
#define WRMT_VENDOR_ID   0x057e
#define WRMT_PRODUCT_ID  0x0306

#define WRMT_SERVICE_CLASS_MAJOR 0x01
#define WRMT_DEVICE_CLASS_MAJOR  0x05
#define WRMT_DEVICE_CLASS_MINOR  0x01

#define WRMT_CONTROL_CHANNEL_PSM  0x11
#define WRMT_INTERRUPT_CHANNEL_PSM  0x13

#define WRMT_BUFFER_SIZE 22

/**
* output report id
**/
#define WRMT_OUTPUT_REPORT_ID_FIRST                  0x11
#define WRMT_OUTPUT_REPORT_ID_LED_AND_FORCE_FEEDBACK 0x11
#define WRMT_OUTPUT_REPORT_ID_REQUEST_REPORT_TYPE    0x12
#define WRMT_OUTPUT_REPORT_ID_IR_SENSOR_ENABLE       0x13
#define WRMT_OUTPUT_REPORT_ID_SPEAKER_ENABLE         0x14
#define WRMT_OUTPUT_REPORT_ID_CONTROLLER_STATUS      0x15
#define WRMT_OUTPUT_REPORT_ID_WRITE_DATA             0x16
#define WRMT_OUTPUT_REPORT_ID_READ_DATA              0x17
#define WRMT_OUTPUT_REPORT_ID_SPEAKER_DATA           0x18
#define WRMT_OUTPUT_REPORT_ID_SPEAKER_MUTE           0x19
#define WRMT_OUTPUT_REPORT_ID_IR_SENSOR_ENABLE2      0x1A
#define WRMT_OUTPUT_REPORT_ID_LAST                   0x1A

#define WRMT_Impl_GetOutputReportSize(report_id) \
	(WRMT_OUTPUT_REPORT_SIZE_TABLE[(report_id) - WRMT_OUTPUT_REPORT_ID_FIRST]) 

/**
* types
**/
struct wrmt_wiiremote_impl;
typedef struct wrmt_wiiremote_impl WRMT_WiiRemoteImpl;

/**
* variables
**/
extern
const
int
WRMT_OUTPUT_REPORT_SIZE_TABLE[];

/**
* functions
**/
extern
int
WRMT_Impl_Init(int inquiry_length_in_sec);

extern
void
WRMT_Impl_Quit();

extern
void
WRMT_Impl_Sleep(int ms);

extern
WRMT_IOReturn
WRMT_Impl_Poll(int *updated_device_index_pointer);

extern
int
WRMT_Impl_GetNumWiiRemote();

extern
WRMT_WiiRemoteImpl *
WRMT_Impl_GetWiiRemoteAt(int device_index);

extern
WRMT_IOReturn
WRMT_WiiRemoteImpl_Open(WRMT_WiiRemoteImpl *self);

extern
int
WRMT_WiiRemoteImpl_IsOpened(WRMT_WiiRemoteImpl *self);

extern
void
WRMT_WiiRemoteImpl_Close(WRMT_WiiRemoteImpl *self);

extern
unsigned char *
WRMT_WiiRemoteImpl_GetOutputBuffer(WRMT_WiiRemoteImpl *self);

extern
unsigned char *
WRMT_WiiRemoteImpl_GetInputBuffer(WRMT_WiiRemoteImpl *self);

extern
WRMT_IOReturn
WRMT_WiiRemoteImpl_OutputToDevice(WRMT_WiiRemoteImpl *self);


#ifdef __cplusplus
}
#endif

#endif /* WIIREMOTE_IMPL_H */

