/************************************************************
* Copyright (C) 2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/
#ifndef DEBUG_LOG_H
#define DEBUG_LOG_H

#if (defined NDEBUG) && !(defined DEBUG_LOG_DISABLED)
# define DEBUG_LOG_DISABLED
#endif

#ifdef DEBUG_LOG_DISABLED

# if (defined __GNUC__) || ((defined __STDC_VERSION__) &&(__STDC_VERSION__ >= 199901L))
#  define DebugLog(fmt, ...) ((void)(0))
# else
#  define DebugLog
# endif

#else /* Enable DebugLog */
/**
* Please use C99 compiler to enable DebugLog() output.
**/

#include <stdio.h>
#include <stdarg.h>
#include <string.h>

static
void
DebugLog_Output(const char *file,
		int line,
		const char *func,
		const char *format,
		...)
{
	static const char *DebugLog_ENABLED_FUNCTION_LIST[] = {
		/* wiiremote.h */
/*		"WRMT_SetError", */
/*		"WRMT_GetError", */
		"WRMT_Init",
		"WRMT_Quit",
/*		"WRMT_Sleep", */
/*		"WRMT_Update", */
/*		"WRMT_Poll", */
		"WRMT_GetNumWiiRemote",
		"WRMT_GetWiiRemoteAt",
		"WRMT_WiiRemote_Open",
		"WRMT_WiiRemote_IsOpened",
		"WRMT_WiiRemote_Close",
		"WRMT_WiiRemote_IsEnabled",
		"WRMT_WiiRemote_SetEnabled",
/*		"WRMT_WiiRemote_GetState", */
		"WRMT_WiiRemote_SetState",
		"WRMT_WiiRemote_WriteDataToMemory",
		/* wiiremote.c */
/*		"WRMT_WiiRemote_ParseButtonState", */
/*		"WRMT_WiiRemote_ParseMotionState", */
/*		"WRMT_WiiRemote_ParseIRState", */
		"WRMT_WiiRemote_ParseBatteryLevel", 
		"WRMT_WiiRemote_ParseReport", 
/*		"WRMT_WiiRemote_ClearOutputBuffer", */
/*		"WRMT_WiiRemote_OutputToDevice", */
		"WRMT_WiiRemote_SendControllerStatusRequest", 
		"WRMT_WiiRemote_SendReportTypeRequest", 
		"WRMT_WiiRemote_SendDeviceState", 
		"WRMT_WiiRemote_SendIRParameters", 
		"WRMT_WiiRemote_SendSpeakerParameters", 
		/* linux/wiiremote_linux_bluez.c */
/*		"IsWiiRemote", */
/*		"WRMT_WiiRemoteImpl_InitWithAddress", */
		/* darwin/WiiRemoteImplement.h */
		"-[WiiRemoteImplement initWithDevice:]",
		"-[WiiRemoteImplement open]",
		"-[WiiRemoteImplement openControlChannel]",
		"-[WiiRemoteImplement openInterruptChannel]",
/*		"-[WiiRemoteImplement isOpened]", */
		"-[WiiRemoteImplement close]",
		"-[WiiRemoteImplement writeToDevice]",
		"-[WiiRemoteImplement inputBuffer]",
		"-[WiiRemoteImplement outputBuffer]",
		/* darwin/WiiRemoteImplement.m */
		"-[ChannelHandler initWithWiiRemote:]",
		"-[ControlChannelHandler l2capChannelData:data:length:]",
		"-[ControlChannelHandler l2capChannelOpenComplete:status:]",
		"-[ControlChannelHandler l2capChannelClosed:]",
		"-[ControlChannelHandler l2capChannelReconfigured:]",
		"-[ControlChannelHandler l2capChannelWriteComplete:refcon:status:]",
		"-[ControlChannelHandler l2capChannelQueueSpaceAvailable:]",
		"-[InterruptChannelHandler l2capChannelData:data:length:]",
		"-[InterruptChannelHandler l2capChannelOpenComplete:status:]",
		"-[InterruptChannelHandler l2capChannelClosed:]",
		"-[InterruptChannelHandler l2capChannelReconfigured:]",
		"-[InterruptChannelHandler l2capChannelWriteComplete:refcon:status:]",
		"-[InterruptChannelHandler l2capChannelQueueSpaceAvailable:]",
		"-[WiiRemoteImplement connectionComplete:status:]",
		"-[WiiRemoteImplement sdpQueryComplete:status:]",
/*		"-[WiiRemoteImplement setControlChannelState:]", */
/*		"-[WiiRemoteImplement setInterruptChannelState:]", */
		/* darwin/WiiRemoteManager.h */
		"-[WiiRemoteManager initWithInquiryLength:]",
		"-[WiiRemoteManager startInquiry]",
		"-[WiiRemoteManager stopInquiry]",
		"-[WiiRemoteManager status]",
		"-[WiiRemoteManager setStatus:newstatus]",
		"-[WiiRemoteManager numberOfWiiRemotes]",
		"-[WiiRemoteManager wiiRemoteAt:]",
		"-[WiiRemoteManager closeAllWiiRemotes]",
		"-[WiiRemoteManager clear]",
		/* darwin/WiiRemoteManager.m */
	};
	va_list argptr;
	int list_length, i, enable;

	va_start(argptr, format);

	list_length = sizeof(DebugLog_ENABLED_FUNCTION_LIST)/sizeof(const char *);
	enable = 0;
	for (i = 0;i < list_length;i++)
	{
		if (strcmp(DebugLog_ENABLED_FUNCTION_LIST[i], func) == 0)
		{
			enable = 1;
			break;
		}
	}

	if (enable)
	{
		fprintf(stderr, "%s(%s:%d) : ", func, file, line);
		vfprintf(stderr, format, argptr);
	}

	va_end(argptr);
}

# define DebugLog(fmt, ...) DebugLog_Output(__FILE__, __LINE__, __func__, fmt, ## __VA_ARGS__)

#endif /* DEBUG_LOG_DISABLED */

#endif /* DEBUG_LOG_H */
