/************************************************************
* Copyright (C) 2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#import "wiiremote_impl.h"

#import "WiiRemoteImplement.h"

#define MAC_OS_X_VERSION_MIN_REQUIRED MAC_OS_X_VERSION_10_2

#import <Foundation/NSArray.h>
#import <IOBluetooth/objc/IOBluetoothDeviceInquiry.h>
#import <IOBluetooth/objc/IOBluetoothDevice.h>

typedef enum WiiRemoteManagerStatus
{
	WiiRemoteManagerStatusInquiryStarting    = 0x1,
	WiiRemoteManagerStatusInquiryRunning     = 0x2,
	WiiRemoteManagerStatusInquiryStopping    = 0x3,
	WiiRemoteManagerStatusInquiryStoped      = 0x4,
} WiiRemoteManagerStatus;

@interface WiiRemoteManager : NSObject
{
	IOBluetoothDeviceInquiry *inquiry;
	NSMutableArray *wiiRemoteArray;
	WiiRemoteManagerStatus status;
}
- initWithInquiryLength:(int)inquiry_length_in_sec;
- (void)startInquiry;
- (void)stopInquiry;
- (WiiRemoteManagerStatus)status;
- (void)setStatus:(WiiRemoteManagerStatus)newstatus;
- (int)numberOfWiiRemotes;
- (WiiRemoteImplement *)wiiRemoteAt:(int)index;
- (void)closeAllWiiRemotes;
- (void)clear;
@end

