/************************************************************
* Copyright (C) 2007 Masahiko SAWAI All Rights Reserved. 
************************************************************/

#import "IOBluetoothDevice_Wiiremote.h"

#import "wiiremote_impl.h"

#import <Foundation/NSString.h>

@implementation IOBluetoothDevice (WiiRemote)
- (BOOL)isWiiremote
{
	BOOL result = NO;
	BluetoothClassOfDevice class;
	BluetoothServiceClassMajor serviceClass;
	BluetoothDeviceClassMajor deviceClassMajor;
	BluetoothDeviceClassMinor deviceClassMinor;

	class = [self getClassOfDevice];
	serviceClass = [self getServiceClassMajor];
	deviceClassMajor = [self getDeviceClassMajor];
	deviceClassMinor = [self getDeviceClassMinor];

	if (class == WRMT_DEVICE_CLASS &&
		serviceClass == WRMT_SERVICE_CLASS_MAJOR &&
		deviceClassMajor == WRMT_DEVICE_CLASS_MAJOR &&
		deviceClassMinor == WRMT_DEVICE_CLASS_MINOR )
	{
#ifdef WRMT_DEVICE_NAME_CHECK
		NSString *name = [self getName];
		NSString *wiiremoteName = [NSString stringWithUTF8String:(const char *)WRMT_DEVICE_NAME];
		if ([name isEqualToString:wiiremoteName])
		{
			result = 1;
		}
#else
		result = 1;
#endif
	}
	return result;
}
@end
