// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// UssSocket.cpp
// $Id: UssSocket.cpp,v 1.13 2001/08/10 04:27:09 seagull Exp $
//

#include <netdb.h>

#include "UssCommon.h"
#include "UssFileDescriptor.h"
#include "UssSocket.h"

////////////////////////////////////////////////////////////////////////
//



int
UssSocket::open()
{
  throw new EUssBadOperation(this);
}



////////////////////////////////////////////////////////////////////////
//




int
UssClientSocket::open(char const* host, int port, bool async)
{
  sockaddr_in addr;
  hostent* he;

  addr.sin_family = PF_INET;
  addr.sin_port = htons(port);

  he = ::gethostbyname(host);
  if (he == NULL)
    throw new EUssOSError();

  ::memcpy(static_cast<void*>(&addr.sin_addr),
           static_cast<void*>(he->h_addr),
           sizeof(addr.sin_addr));

  return open(addr, async);
}




int
UssClientSocket::open(sockaddr_in& addr, bool async)
{
  int fd = ::socket(PF_INET, SOCK_STREAM, 0);
  if (fd < 0)
    throw new EUssOSError();
  int oldfl = 0;
  if (async)
  {
    oldfl = ::fcntl(fd, F_GETFL);
    ::fcntl(fd, F_SETFL, O_NONBLOCK);
  }

  if (::connect(fd, (sockaddr*)&addr, sizeof(addr)) < 0 &&
      errno != EINPROGRESS)
    {
      ::close(fd);
      throw new EUssOSError();
    }

  setFD(fd);

  if (async)
    ::fcntl(fd, F_SETFL, oldfl);

  return fd;
}


////////////////////////////////////////////////////////////////////////
//


int
UssServerSocket::open(int port, long allowfrom /*= INADDR_ANY*/, int backlog /*=5*/)
{
  sockaddr_in addr;
  addr.sin_family = PF_INET;
  addr.sin_port = htons(port);
  addr.sin_addr.s_addr = htonl(allowfrom);

  int fd = ::socket(PF_INET, SOCK_STREAM, 0);
  if (fd < 0)
    throw new EUssOSError();

  int optval = 1;
  ::setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, (void*)&optval, sizeof(optval));

  if (::bind(fd, (sockaddr*)&addr, sizeof(addr)) < 0 || ::listen(fd, backlog) < 0)
    {
      ::close(fd);
      throw new EUssOSError();
    }

  setFD(fd);

  return fd;
}





int
UssServerSocket::accept(UssSocket* sock)
{
  testOpened();

  int fd = ::accept(getFD(), 0, NULL);
  if (fd < 0)
    throw new EUssOSError();
    
  sock->attach(fd);
    
  return fd;
}

