// -*- mode:c++; indent-tabs-moe:nil; tab-width:2; -*-
//
// $Id: UssIOBuffer_Slide.h,v 1.10 2001/07/16 17:28:55 seagull Exp $
//


#if !defined(USS_H_IOBuffer_Slide)
#define USS_H_IOBuffer_Slide

#include <memory.h>

class UssIOBuffer_Slide : public UssIOBuffer_Raw
{
public:

  virtual int read(void* buf, int len);
  virtual int write_impl(void const* buf, int len);

  virtual void reset()
  {
    m_pWritePtr = m_pBuffer;
  }

  virtual size_t getFreeSize() const
  {
    return m_pBufferTail - m_pWritePtr;
  }
  virtual size_t getUsedSize() const
  {
    return m_pWritePtr - m_pBuffer;
  }

  virtual bool isEmpty() const
  {
    return m_pWritePtr == m_pBuffer;
  }
  virtual bool isFull() const
  {
    return m_pWritePtr == m_pBufferTail;
  }

  virtual int flush();
  virtual int fetch();

  virtual bool lookAhead(int offset, uint8_t* p);


protected:
  uint8_t* m_pWritePtr;
};

#endif
// EOF
