// -*- mode:c++; indent-tabs-mode:nil; tab-width:2; -*-
//
// $Id: UssIOBuffer_Ring.h,v 1.12 2001/07/16 17:28:55 seagull Exp $
//

#if !defined(USS_H_IOBuffer_Ring)
#define USS_H_IOBuffer_Ring


/**
   󥰥Хåե 饹
 */
class UssIOBuffer_Ring : public UssIOBuffer_Raw
{
public:
  UssIOBuffer_Ring()
  {
    m_pReadPtr = NULL;
    m_pWritePtr = NULL;
  }

  virtual int read(void* buff, int len);
  virtual int write_impl(void const* buff, int len);

  virtual void reset()
  {
    m_pReadPtr = NULL;
    m_pWritePtr = m_pBuffer;
  }

  virtual size_t getFreeSize() const
  {
    if (isEmpty()) return getBufferSize();
    if (isWrapped())
      return m_pReadPtr - m_pWritePtr;
    return getBufferSize() - (m_pWritePtr - m_pReadPtr);
  }


  virtual size_t getUsedSize() const
  {
    if (isEmpty()) return 0;
    if (isWrapped())
      return (m_pBufferTail - m_pReadPtr) +
        (m_pWritePtr - m_pBuffer);
    return m_pWritePtr - m_pReadPtr;
  }


  virtual bool isEmpty() const { return m_pReadPtr == NULL; }
  virtual bool isFull() const { return m_pReadPtr == m_pWritePtr; }

  /**
     󥰥Хåեޤ֤򵯤Ƥ뤫ޤ
   */
  bool isWrapped() const
  {
    return (!isEmpty()  && m_pReadPtr >= m_pWritePtr);
  }


  virtual int flush();
  virtual int fetch();
  virtual bool lookAhead(int offset, uint8_t* p);

protected:
  uint8_t* m_pReadPtr;  // pointer for head of used area. must be NULL if empty.
  uint8_t* m_pWritePtr; // pointer for head of free area in buffer
};


#endif

//EOF
